/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.NotCancelableProgressMonitor;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.WorkbenchRunnableAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ChangeExceptionHandler {
    private Shell fParent;
    private String fName;

    public ChangeExceptionHandler(Shell parent, Refactoring refactoring) {
        this.fParent = parent;
        this.fName = refactoring.getName();
    }

    public void handle(Change change, RuntimeException exception) {
        RefactoringUIPlugin.log(exception);
        Status status = null;
        status = exception.getMessage() == null ? new Status(4, RefactoringUIPlugin.getPluginId(), 4, RefactoringUIMessages.getString("ChangeExceptionHandler.no_details"), (Throwable)exception) : new Status(4, RefactoringUIPlugin.getPluginId(), 4, exception.getMessage(), (Throwable)exception);
        this.handle(change, (IStatus)status);
    }

    public void handle(Change change, CoreException exception) {
        RefactoringUIPlugin.log((Throwable)exception);
        this.handle(change, exception.getStatus());
    }

    private void handle(Change change, IStatus status) {
        Change undo;
        if (change instanceof CompositeChange && (undo = ((CompositeChange)change).getUndoUntilException()) != null) {
            RefactoringUIPlugin.log(status);
            RefactorErrorDialog dialog = new RefactorErrorDialog(this.fParent, RefactoringUIMessages.getString("ChangeExceptionHandler.refactoring"), RefactoringUIMessages.getFormattedString("ChangeExceptionHandler.unexpected_exception", new String[]{this.fName}), status, 7);
            int result = dialog.open();
            if (result == 0) {
                this.performUndo(undo);
            }
            return;
        }
        ErrorDialog dialog = new ErrorDialog(this.fParent, RefactoringUIMessages.getString("ChangeExceptionHandler.refactoring"), RefactoringUIMessages.getFormattedString("ChangeExceptionHandler.unexpected_exception", new String[]{this.fName}), status, 7);
        dialog.open();
    }

    private void performUndo(final Change undo) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", 11);
                undo.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                if (undo.isValid((IProgressMonitor)new SubProgressMonitor(monitor, 1)).hasFatalError()) {
                    monitor.done();
                    return;
                }
                undo.perform((IProgressMonitor)new SubProgressMonitor(monitor, 9));
            }
        };
        WorkbenchRunnableAdapter adapter = new WorkbenchRunnableAdapter(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.fParent);
        try {
            dialog.run(false, false, (IRunnableWithProgress)adapter);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.fParent, RefactoringUIMessages.getString("ChangeExceptionHandler.rollback.title"), RefactoringUIMessages.getString("ChangeExceptionHandler.rollback.message") + this.fName);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private static class RefactorErrorDialog
    extends ErrorDialog {
        public RefactorErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button ok = this.getButton(0);
            ok.setText(RefactoringUIMessages.getString("ChangeExceptionHandler.undo"));
            Button abort = this.createButton(parent, 1, RefactoringUIMessages.getString("ChangeExceptionHandler.abort"), true);
            abort.moveBelow((Control)ok);
            abort.setFocus();
        }

        protected Control createMessageArea(Composite parent) {
            Control result = super.createMessageArea(parent);
            new Label(parent, 0);
            Label label = new Label(parent, 0);
            label.setText(RefactoringUIMessages.getString("ChangeExceptionHandler.button_explanation"));
            label.setLayoutData((Object)new GridData(768));
            RefactorErrorDialog.applyDialogFont((Control)result);
            return result;
        }
    }
}

