/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.core.dom.rewrite.NodeRewriteEvent;
import org.eclipse.jdt.internal.core.dom.rewrite.RewriteEvent;

public class ListRewriteEvent
extends RewriteEvent {
    public static final int NEW = 1;
    public static final int OLD = 2;
    public static final int BOTH = 3;
    private List originalNodes;
    private List listEntries;

    public ListRewriteEvent(List originalNodes) {
        this.originalNodes = new ArrayList(originalNodes);
    }

    public ListRewriteEvent(RewriteEvent[] children) {
        this.listEntries = new ArrayList(children.length * 2);
        this.originalNodes = new ArrayList(children.length * 2);
        for (int i = 0; i < children.length; ++i) {
            RewriteEvent curr = children[i];
            this.listEntries.add(curr);
            if (curr.getOriginalValue() == null) continue;
            this.originalNodes.add(curr.getOriginalValue());
        }
    }

    private List getEntries() {
        if (this.listEntries == null) {
            int nNodes = this.originalNodes.size();
            this.listEntries = new ArrayList(nNodes * 2);
            for (int i = 0; i < nNodes; ++i) {
                ASTNode node = (ASTNode)this.originalNodes.get(i);
                this.listEntries.add(new NodeRewriteEvent(node, node));
            }
        }
        return this.listEntries;
    }

    public int getChangeKind() {
        if (this.listEntries != null) {
            for (int i = 0; i < this.listEntries.size(); ++i) {
                RewriteEvent curr = (RewriteEvent)this.listEntries.get(i);
                if (curr.getChangeKind() == 0) continue;
                return 8;
            }
        }
        return 0;
    }

    public boolean isListRewrite() {
        return true;
    }

    public RewriteEvent[] getChildren() {
        List entries = this.getEntries();
        return entries.toArray(new RewriteEvent[entries.size()]);
    }

    public Object getOriginalValue() {
        return this.originalNodes;
    }

    public Object getNewValue() {
        List entries = this.getEntries();
        ArrayList<Object> res = new ArrayList<Object>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            RewriteEvent curr = (RewriteEvent)entries.get(i);
            Object newVal = curr.getNewValue();
            if (newVal == null) continue;
            res.add(newVal);
        }
        return res;
    }

    public RewriteEvent removeEntry(ASTNode originalEntry) {
        return this.replaceEntry(originalEntry, null);
    }

    public RewriteEvent replaceEntry(ASTNode originalEntry, ASTNode newEntry) {
        if (originalEntry == null) {
            throw new IllegalArgumentException();
        }
        List entries = this.getEntries();
        int nEntries = entries.size();
        for (int i = 0; i < nEntries; ++i) {
            NodeRewriteEvent curr = (NodeRewriteEvent)entries.get(i);
            if (curr.getOriginalValue() != originalEntry) continue;
            curr.setNewValue(newEntry);
            return curr;
        }
        return null;
    }

    public void revertChange(NodeRewriteEvent event) {
        Object originalValue = event.getOriginalValue();
        if (originalValue == null) {
            List entries = this.getEntries();
            entries.remove(event);
        } else {
            event.setNewValue(originalValue);
        }
    }

    public int getIndex(ASTNode node, int kind) {
        List entries = this.getEntries();
        for (int i = entries.size() - 1; i >= 0; --i) {
            RewriteEvent curr = (RewriteEvent)entries.get(i);
            if ((kind & 2) != 0 && curr.getOriginalValue() == node) {
                return i;
            }
            if ((kind & 1) == 0 || curr.getNewValue() != node) continue;
            return i;
        }
        return -1;
    }

    public RewriteEvent insert(ASTNode insertedNode, int insertIndex) {
        NodeRewriteEvent change = new NodeRewriteEvent(null, insertedNode);
        if (insertIndex != -1) {
            this.getEntries().add(insertIndex, change);
        } else {
            this.getEntries().add(change);
        }
        return change;
    }

    public void setNewValue(ASTNode newValue, int insertIndex) {
        NodeRewriteEvent curr = (NodeRewriteEvent)this.getEntries().get(insertIndex);
        curr.setNewValue(newValue);
    }

    public int getChangeKind(int index) {
        return ((NodeRewriteEvent)this.getEntries().get(index)).getChangeKind();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" [list change\n\t");
        RewriteEvent[] events = this.getChildren();
        for (int i = 0; i < events.length; ++i) {
            if (i != 0) {
                buf.append("\n\t");
            }
            buf.append(events[i]);
        }
        buf.append("\n]");
        return buf.toString();
    }
}

