/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CreateCompilationUnitOperation;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragmentInfo;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;

public class PackageFragment
extends Openable
implements IPackageFragment,
SuffixConstants {
    protected static final IClassFile[] NO_CLASSFILES = new IClassFile[0];
    protected static final ICompilationUnit[] NO_COMPILATION_UNITS = new ICompilationUnit[0];

    protected PackageFragment(PackageFragmentRoot root, String name) {
        super(root, name);
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        int kind = this.getKind();
        String extType = kind == 1 ? "java" : "class";
        HashSet<IParent> vChildren = new HashSet<IParent>();
        try {
            PackageFragmentRoot root = this.getPackageFragmentRoot();
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            char[][] exclusionPatterns = root.fullExclusionPatternChars();
            IResource[] members = ((IContainer)underlyingResource).members();
            int max = members.length;
            for (int i = 0; i < max; ++i) {
                IParent childElement;
                String extension;
                IResource child = members[i];
                if (child.getType() == 2 || Util.isExcluded(child, inclusionPatterns, exclusionPatterns) || (extension = child.getProjectRelativePath().getFileExtension()) == null || !extension.equalsIgnoreCase(extType)) continue;
                if (kind == 1 && Util.isValidCompilationUnitName(child.getName())) {
                    childElement = new CompilationUnit(this, child.getName(), DefaultWorkingCopyOwner.PRIMARY);
                    vChildren.add(childElement);
                    continue;
                }
                if (!Util.isValidClassFileName(child.getName())) continue;
                childElement = this.getClassFile(child.getName());
                vChildren.add(childElement);
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        if (kind == 1) {
            ICompilationUnit[] primaryCompilationUnits = this.getCompilationUnits(DefaultWorkingCopyOwner.PRIMARY);
            int length = primaryCompilationUnits.length;
            for (int i = 0; i < length; ++i) {
                ICompilationUnit primary = primaryCompilationUnits[i];
                vChildren.add(primary);
            }
        }
        IJavaElement[] children = new IJavaElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    public boolean containsJavaResources() throws JavaModelException {
        return ((PackageFragmentInfo)this.getElementInfo()).containsJavaResources();
    }

    public void copy(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (container == null) {
            throw new IllegalArgumentException(Util.bind("operation.nullContainer"));
        }
        IJavaElement[] elements = new IJavaElement[]{this};
        IJavaElement[] containers = new IJavaElement[]{container};
        IJavaElement[] siblings = null;
        if (sibling != null) {
            siblings = new IJavaElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaModel().copy(elements, containers, siblings, renamings, force, monitor);
    }

    public ICompilationUnit createCompilationUnit(String cuName, String contents, boolean force, IProgressMonitor monitor) throws JavaModelException {
        CreateCompilationUnitOperation op = new CreateCompilationUnitOperation(this, cuName, contents, force);
        op.runOperation(monitor);
        return new CompilationUnit(this, cuName, DefaultWorkingCopyOwner.PRIMARY);
    }

    protected Object createElementInfo() {
        return new PackageFragmentInfo();
    }

    public void delete(boolean force, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] elements = new IJavaElement[]{this};
        this.getJavaModel().delete(elements, force, monitor);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PackageFragment)) {
            return false;
        }
        return super.equals(o);
    }

    public IClassFile getClassFile(String classFileName) {
        if (!org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(classFileName)) {
            throw new IllegalArgumentException(Util.bind("element.invalidClassFileName"));
        }
        return new ClassFile(this, classFileName);
    }

    public IClassFile[] getClassFiles() throws JavaModelException {
        if (this.getKind() == 1) {
            return NO_CLASSFILES;
        }
        ArrayList list = this.getChildrenOfType(6);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }

    public ICompilationUnit getCompilationUnit(String cuName) {
        if (!org.eclipse.jdt.internal.compiler.util.Util.isJavaFileName(cuName)) {
            throw new IllegalArgumentException(Util.bind("convention.unit.notJavaName"));
        }
        return new CompilationUnit(this, cuName, DefaultWorkingCopyOwner.PRIMARY);
    }

    public ICompilationUnit[] getCompilationUnits() throws JavaModelException {
        if (this.getKind() == 2) {
            return NO_COMPILATION_UNITS;
        }
        ArrayList list = this.getChildrenOfType(5);
        ICompilationUnit[] array = new ICompilationUnit[list.size()];
        list.toArray(array);
        return array;
    }

    public ICompilationUnit[] getCompilationUnits(WorkingCopyOwner owner) {
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, false);
        if (workingCopies == null) {
            return JavaModelManager.NO_WORKING_COPY;
        }
        int length = workingCopies.length;
        ICompilationUnit[] result = new ICompilationUnit[length];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            ICompilationUnit wc = workingCopies[i];
            if (!this.equals(wc.getParent()) || Util.isExcluded(wc)) continue;
            result[index++] = wc;
        }
        if (index != length) {
            ICompilationUnit[] iCompilationUnitArray = result;
            result = new ICompilationUnit[index];
            System.arraycopy(iCompilationUnitArray, 0, result, 0, index);
        }
        return result;
    }

    public int getElementType() {
        return 4;
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
            case '(': {
                String classFileName = memento.nextToken();
                JavaElement classFile = (JavaElement)((Object)this.getClassFile(classFileName));
                return classFile.getHandleFromMemento(memento, owner);
            }
            case '{': {
                String cuName = memento.nextToken();
                CompilationUnit cu = new CompilationUnit(this, cuName, owner);
                return cu.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '<';
    }

    public int getKind() throws JavaModelException {
        return ((IPackageFragmentRoot)this.getParent()).getKind();
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return ((PackageFragmentInfo)this.getElementInfo()).getNonJavaResources(this.getResource(), this.getPackageFragmentRoot());
    }

    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return root.getPath().append(this.getElementName().replace('.', '/'));
    }

    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getResource();
        }
        String elementName = this.getElementName();
        if (elementName.length() == 0) {
            return root.getResource();
        }
        return ((IContainer)root.getResource()).getFolder((IPath)new Path(this.getElementName().replace('.', '/')));
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        IResource rootResource = this.parent.getUnderlyingResource();
        if (rootResource == null) {
            return null;
        }
        if (rootResource.getType() == 2 || rootResource.getType() == 4) {
            IContainer folder = (IContainer)rootResource;
            String[] segs = Signature.getSimpleNames(this.name);
            for (int i = 0; i < segs.length; ++i) {
                IResource child = folder.findMember(segs[i]);
                if (child == null || child.getType() != 2) {
                    throw this.newNotPresentException();
                }
                folder = (IFolder)child;
            }
            return folder;
        }
        return rootResource;
    }

    public boolean hasChildren() throws JavaModelException {
        return this.getChildren().length > 0;
    }

    public boolean hasSubpackages() throws JavaModelException {
        IJavaElement[] packages = ((IPackageFragmentRoot)this.getParent()).getChildren();
        String elementName = this.getElementName();
        int nameLength = elementName.length();
        String packageName = this.isDefaultPackage() ? elementName : elementName + ".";
        for (int i = 0; i < packages.length; ++i) {
            String otherName = packages[i].getElementName();
            if (otherName.length() <= nameLength || !otherName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultPackage() {
        return this.getElementName().length() == 0;
    }

    public void move(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (container == null) {
            throw new IllegalArgumentException(Util.bind("operation.nullContainer"));
        }
        IJavaElement[] elements = new IJavaElement[]{this};
        IJavaElement[] containers = new IJavaElement[]{container};
        IJavaElement[] siblings = null;
        if (sibling != null) {
            siblings = new IJavaElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaModel().move(elements, containers, siblings, renamings, force, monitor);
    }

    public void rename(String newName, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Util.bind("element.nullName"));
        }
        IJavaElement[] elements = new IJavaElement[]{this};
        IJavaElement[] dests = new IJavaElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        this.getJavaModel().rename(elements, dests, renamings, force, monitor);
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (tab == 0) {
            super.toStringChildren(tab, buffer, info);
        }
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (this.getElementName().length() == 0) {
            buffer.append("<default>");
        } else {
            this.toStringName(buffer);
        }
        if (info == null) {
            buffer.append(" (not open)");
        } else if (tab > 0) {
            buffer.append(" (...)");
        }
    }
}

