/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.builder.DevClassPathHelper;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;
import org.eclipse.pde.internal.ui.build.ClasspathHelper;

public class BuildPluginAction
extends BaseBuildAction {
    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        ModelBuildScriptGenerator generator = new ModelBuildScriptGenerator();
        ModelBuildScriptGenerator.setOutputFormat((String)AbstractScriptGenerator.getDefaultOutputFormat());
        ModelBuildScriptGenerator.setEmbeddedSource((boolean)AbstractScriptGenerator.getDefaultEmbeddedSource());
        ModelBuildScriptGenerator.setForceUpdateJar((boolean)AbstractScriptGenerator.getForceUpdateJarFormat());
        ModelBuildScriptGenerator.setConfigInfo((String)AbstractScriptGenerator.getDefaultConfigInfos());
        IProject project = this.fManifestFile.getProject();
        generator.setWorkingDirectory(project.getLocation().toOSString());
        String url = ClasspathHelper.getDevEntriesProperties(project.getLocation().addTrailingSeparator().toString() + "dev.properties", false);
        generator.setDevEntries(new DevClassPathHelper(url));
        generator.setPluginPath(TargetPlatform.createPluginPath());
        generator.setBuildingOSGi(PDECore.getDefault().getModelManager().isOSGiRuntime());
        try {
            IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(project);
            if (model != null) {
                generator.setModelId(model.getPluginBase().getId());
                generator.generate();
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

