/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class InstancePreferences
extends EclipsePreferences {
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;
    private IPath location;
    private static Set loadedNodes = new HashSet();
    private static boolean initialized = false;
    private static IPath baseLocation = InternalPlatform.getDefault().getMetaArea().getStateLocation("org.eclipse.core.runtime");

    public InstancePreferences() {
        this(null, null);
    }

    private InstancePreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
        this.initializeChildren();
        String path = this.absolutePath();
        this.segmentCount = InstancePreferences.getSegmentCount(path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = InstancePreferences.getSegment(path, 1);
        if (this.qualifier == null) {
            return;
        }
        this.location = this.computeLocation(baseLocation, this.qualifier);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void loadLegacy() {
        block20: {
            path = new Path(this.absolutePath());
            if (path.segmentCount() != 2) {
                return;
            }
            bundleName = path.segment(1);
            prefFile = InternalPlatform.getDefault().getMetaArea().getPreferenceLocation(bundleName, false).toFile();
            if (!prefFile.exists()) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Legacy plug-in preference file not found: " + prefFile);
                }
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Loading legacy preferences from " + prefFile);
            }
            input = null;
            values = new Properties();
            try {
                input = new BufferedInputStream(new FileInputStream(prefFile));
                values.load(input);
                var8_6 = null;
                ** if (input == null) goto lbl-1000
            }
            catch (Throwable var7_14) {
                block22: {
                    var8_8 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            if (!InternalPlatform.DEBUG_PREFERENCES) break block22;
                            Policy.debug("IOException encountered closing legacy preference file " + prefFile);
                            e.printStackTrace();
                        }
                    }
                }
                throw var7_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    input.close();
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        Policy.debug("IOException encountered closing legacy preference file " + prefFile);
                        e.printStackTrace();
                    }
                }
            }
lbl-1000:
            // 4 sources

            {
                break block20;
                catch (IOException e) {
                    block21: {
                        if (InternalPlatform.DEBUG_PREFERENCES) {
                            Policy.debug("IOException encountered loading legacy preference file " + prefFile);
                        }
                        var8_7 = null;
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException e) {
                                if (!InternalPlatform.DEBUG_PREFERENCES) break block21;
                                Policy.debug("IOException encountered closing legacy preference file " + prefFile);
                                e.printStackTrace();
                            }
                        }
                    }
                    return;
                }
            }
        }
        i = values.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            value = values.getProperty(key);
            if (value == null) continue;
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Loaded legacy preference: " + key + " -> " + value);
            }
            if (value.equals(oldValue = this.internalPut(key, value))) continue;
            this.makeDirty();
        }
        if (!prefFile.delete() && InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Unable to delete legacy preferences file: " + prefFile);
        }
    }

    protected IPath getLocation() {
        return this.location;
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences node = this;
            for (int i = 2; i < this.segmentCount; ++i) {
                node = (IEclipsePreferences)node.parent();
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (initialized || this.parent == null) {
            return;
        }
        try {
            InstancePreferences instancePreferences = this;
            synchronized (instancePreferences) {
                String[] names = this.computeChildren(baseLocation);
                for (int i = 0; i < names.length; ++i) {
                    this.addChild(names[i], null);
                }
            }
        }
        finally {
            initialized = true;
        }
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new InstancePreferences(nodeParent, nodeName);
    }
}

