/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.EditorsInfo;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Commit;
import org.eclipse.team.internal.ccvs.core.client.Diff;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.AdminKSubstListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.DiffListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.EditorsListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.core.util.MoveDeleteHook;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;
import org.eclipse.team.internal.ccvs.core.util.SyncFileWriter;
import org.eclipse.team.internal.core.streams.CRLFtoLFInputStream;
import org.eclipse.team.internal.core.streams.LFtoCRLFInputStream;

public class CVSTeamProvider
extends RepositoryProvider {
    private static final ResourceRuleFactory RESOURCE_RULE_FACTORY = new ResourceRuleFactory(){

        public ISchedulingRule validateEditRule(IResource[] resources) {
            if (resources.length == 0) {
                return null;
            }
            if (resources.length == 1) {
                return resources[0].isReadOnly() ? this.parent(resources[0]) : null;
            }
            HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
            for (int i = 0; i < resources.length; ++i) {
                if (!resources[i].isReadOnly()) continue;
                rules.add(this.parent(resources[i]));
            }
            if (rules.isEmpty()) {
                return null;
            }
            if (rules.size() == 1) {
                return (ISchedulingRule)rules.iterator().next();
            }
            ISchedulingRule[] ruleArray = rules.toArray(new ISchedulingRule[rules.size()]);
            return new MultiRule(ruleArray);
        }
    };
    private static final boolean IS_CRLF_PLATFORM = Arrays.equals(System.getProperty("line.separator").getBytes(), new byte[]{13, 10});
    public static final IStatus OK = new Status(0, "org.eclipse.team.cvs.core", 0, Policy.bind("ok"), null);
    private static final int UNIFIED_FORMAT = 0;
    private static final int CONTEXT_FORMAT = 1;
    private static final int STANDARD_FORMAT = 2;
    private CVSWorkspaceRoot workspaceRoot;
    private IProject project;
    private String comment = "";
    private static MoveDeleteHook moveDeleteHook = new MoveDeleteHook();
    private static IFileModificationValidator fileModificationValidator;
    private static final QualifiedName FETCH_ABSENT_DIRECTORIES_PROP_KEY;
    private static final QualifiedName WATCH_EDIT_PROP_KEY;

    private static IFileModificationValidator getPluggedInValidator() {
        IExtension[] extensions = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.team.cvs.core", "filemodificationvalidator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            CVSProviderPlugin.log(4, Policy.bind("CVSAdapter.noConfigurationElement", new Object[]{extension.getUniqueIdentifier()}), null);
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (IFileModificationValidator)config.createExecutableExtension("run");
        }
        catch (CoreException ex) {
            CVSProviderPlugin.log(4, Policy.bind("CVSAdapter.unableToInstantiate", new Object[]{extension.getUniqueIdentifier()}), ex);
            return null;
        }
    }

    public void deconfigure() {
    }

    public void deconfigured() {
        try {
            EclipseSynchronizer.getInstance().deconfigure(this.getProject(), null);
            this.internalSetWatchEditEnabled(null);
            this.internalSetFetchAbsentDirectories(null);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        ResourceStateChangeListeners.getListener().projectDeconfigured(this.getProject());
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        try {
            this.workspaceRoot = new CVSWorkspaceRoot((IContainer)project);
            if (this.workspaceRoot.getLocalRoot().getFolderSyncInfo() == null) {
                CVSProviderPlugin.log((CoreException)((Object)new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.noFolderInfo", project.getName())))));
            }
        }
        catch (CVSException cVSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(IResource resource, Command.LocalOption[] options, PrintStream stream, IProgressMonitor progress) throws TeamException {
        String[] arguments;
        ICVSFolder commandRoot;
        boolean includeNewFiles = false;
        boolean doNotRecurse = false;
        int format = 2;
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
        if (cvsResource.isFolder()) {
            commandRoot = (ICVSFolder)cvsResource;
            arguments = new String[]{"."};
        } else {
            commandRoot = cvsResource.getParent();
            arguments = new String[]{cvsResource.getName()};
        }
        Session s = new Session(this.workspaceRoot.getRemoteLocation(), commandRoot);
        progress.beginTask(null, 100);
        try {
            s.open(Policy.subMonitorFor(progress, 20), false);
            Command.DIFF.execute(s, Command.NO_GLOBAL_OPTIONS, options, arguments, (ICommandOutputListener)new DiffListener(stream), Policy.subMonitorFor(progress, 80));
        }
        finally {
            s.close();
            progress.done();
        }
        for (int i = 0; i < options.length; ++i) {
            Command.LocalOption option = options[i];
            if (option.equals(Diff.INCLUDE_NEWFILES)) {
                includeNewFiles = true;
                continue;
            }
            if (option.equals(Diff.DO_NOT_RECURSE)) {
                doNotRecurse = true;
                continue;
            }
            if (option.equals(Diff.UNIFIED_FORMAT)) {
                format = 0;
                continue;
            }
            if (!option.equals(Diff.CONTEXT_FORMAT)) continue;
            format = 1;
        }
        if (includeNewFiles) {
            this.newFileDiff(commandRoot, stream, doNotRecurse, format);
        }
    }

    private void newFileDiff(final ICVSFolder resource, final PrintStream stream, final boolean doNotRecurse, final int format) throws CVSException {
        resource.accept(new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (!file.isIgnored() && !file.isManaged()) {
                    CVSTeamProvider.this.addFileToDiff(resource, file, stream, format);
                }
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
                if (!folder.exists() || folder.isIgnored() || doNotRecurse && !folder.equals(resource)) {
                    return;
                }
                folder.acceptChildren(this);
            }
        });
    }

    private void addFileToDiff(ICVSFolder cmdRoot, ICVSFile file, PrintStream stream, int format) throws CVSException {
        String nullFilePrefix = "";
        String newFilePrefix = "";
        String positionInfo = "";
        String linePrefix = "";
        String pathString = file.getRelativePath(cmdRoot);
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(file.getContents()));
        int lines = 0;
        try {
            while (fileReader.readLine() != null) {
                ++lines;
            }
            fileReader.close();
            switch (format) {
                case 0: {
                    nullFilePrefix = "--- ";
                    newFilePrefix = "+++ ";
                    positionInfo = "@@ -0,0 +1," + lines + " @@";
                    linePrefix = "+";
                    break;
                }
                case 1: {
                    nullFilePrefix = "*** ";
                    newFilePrefix = "--- ";
                    positionInfo = "--- 1," + lines + " ----";
                    linePrefix = "+ ";
                    break;
                }
                default: {
                    positionInfo = "0a1," + lines;
                    linePrefix = "> ";
                }
            }
            fileReader = new BufferedReader(new InputStreamReader(file.getContents()));
            stream.println("Index: " + pathString);
            stream.println("===================================================================");
            stream.println("RCS file: " + pathString);
            stream.println("diff -N " + pathString);
            if (lines > 0) {
                if (format != 2) {
                    stream.println(nullFilePrefix + "/dev/null\t1 Jan 1970 00:00:00 -0000");
                    stream.println(newFilePrefix + pathString + "\t1 Jan 1970 00:00:00 -0000");
                }
                if (format == 1) {
                    stream.println("***************");
                    stream.println("*** 0 ****");
                }
                stream.println(positionInfo);
                for (int i = 0; i < lines; ++i) {
                    stream.print(linePrefix);
                    stream.println(fileReader.readLine());
                }
            }
        }
        catch (IOException e) {
            throw CVSException.wrapException(file.getIResource(), Policy.bind("CVSTeamProvider.errorAddingFileToDiff", pathString), e);
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException e1) {}
        }
    }

    public ICVSRepositoryLocation getRemoteLocation() throws CVSException {
        try {
            return this.workspaceRoot.getRemoteLocation();
        }
        catch (CVSException e) {
            try {
                RepositoryProvider.unmap((IProject)this.project);
            }
            catch (TeamException ex) {
                CVSProviderPlugin.log((CoreException)((Object)ex));
            }
            throw e;
        }
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isDirty(IResource resource) {
        Assert.isTrue(false);
        return false;
    }

    public CVSWorkspaceRoot getCVSWorkspaceRoot() {
        return this.workspaceRoot;
    }

    private void checkIsChild(IResource resource) throws CVSException {
        if (!this.isChildResource(resource)) {
            throw new CVSException((IStatus)new Status(4, "org.eclipse.team.cvs.core", -6, Policy.bind("CVSTeamProvider.invalidResource", new Object[]{resource.getFullPath().toString(), this.project.getName()}), null));
        }
    }

    private String[] getValidArguments(IResource[] resources, Command.LocalOption[] options) throws CVSException {
        ArrayList<String> arguments = new ArrayList<String>(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            this.checkIsChild(resources[i]);
            IPath cvsPath = resources[i].getFullPath().removeFirstSegments(1);
            if (cvsPath.segmentCount() == 0) {
                arguments.add(".");
                continue;
            }
            arguments.add(cvsPath.toString());
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private ICVSResource[] getCVSArguments(IResource[] resources) {
        ICVSResource[] cvsResources = new ICVSResource[resources.length];
        for (int i = 0; i < cvsResources.length; ++i) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor(resources[i]);
        }
        return cvsResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteRoot(ICVSRepositoryLocation location, IProgressMonitor monitor) throws TeamException {
        final String root = location.getLocation();
        if (root.equals(this.workspaceRoot.getRemoteLocation())) {
            return;
        }
        try {
            this.workspaceRoot.getLocalRoot().run(new ICVSRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor progress) throws CVSException {
                    try {
                        progress.beginTask(null, 100);
                        IProgressMonitor monitor = Policy.infiniteSubMonitorFor(progress, 100);
                        monitor.beginTask(Policy.bind("CVSTeamProvider.folderInfo", CVSTeamProvider.this.project.getName()), 256);
                        CVSTeamProvider.this.workspaceRoot.getLocalRoot().accept(new ICVSResourceVisitor(this, monitor){
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$monitor = val$monitor;
                            }

                            public void visitFile(ICVSFile file) throws CVSException {
                            }

                            public void visitFolder(ICVSFolder folder) throws CVSException {
                                this.val$monitor.worked(1);
                                FolderSyncInfo info = folder.getFolderSyncInfo();
                                if (info != null) {
                                    this.val$monitor.subTask(Policy.bind("CVSTeamProvider.updatingFolder", info.getRepository()));
                                    folder.setFolderSyncInfo(new FolderSyncInfo(info.getRepository(), 3.access$200(this.this$1), info.getTag(), info.getIsStatic()));
                                    folder.acceptChildren(this);
                                }
                            }
                        });
                    }
                    finally {
                        progress.done();
                    }
                }

                static /* synthetic */ String access$200(3 x0) {
                    return x0.root;
                }
            }, monitor);
        }
        finally {
            monitor.done();
        }
    }

    private boolean isChildResource(IResource resource) {
        return resource.getProject().getName().equals(this.project.getName());
    }

    public void configureProject() throws CoreException {
        ResourceStateChangeListeners.getListener().projectConfigured(this.getProject());
    }

    public IStatus setKeywordSubstitution(final Map changeSet, final String comment, IProgressMonitor monitor) throws TeamException {
        final IStatus[] result = new IStatus[]{ICommandOutputListener.OK};
        this.workspaceRoot.getLocalRoot().run(new ICVSRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) throws CVSException {
                Command.KSubstOption toKSubst;
                HashMap<Command.KSubstOption, ArrayList<ICVSFile>> filesToAdmin = new HashMap<Command.KSubstOption, ArrayList<ICVSFile>>();
                ArrayList<ICVSFile> filesToCommit = new ArrayList<ICVSFile>();
                HashSet<ICVSFile> filesToCommitAsText = new HashSet<ICVSFile>();
                boolean useCRLF = IS_CRLF_PLATFORM && CVSProviderPlugin.getPlugin().isUsePlatformLineend();
                Iterator it = changeSet.entrySet().iterator();
                while (it.hasNext()) {
                    byte[] syncBytes;
                    Command.KSubstOption fromKSubst;
                    Map.Entry entry = it.next();
                    IFile file = (IFile)entry.getKey();
                    toKSubst = (Command.KSubstOption)entry.getValue();
                    CVSTeamProvider.this.checkIsChild((IResource)file);
                    ICVSFile mFile = CVSWorkspaceRoot.getCVSFileFor(file);
                    if (!mFile.isManaged() || toKSubst.equals(fromKSubst = ResourceSyncInfo.getKeywordMode(syncBytes = mFile.getSyncBytes()))) continue;
                    if (ResourceSyncInfo.isAddition(syncBytes)) {
                        mFile.setSyncBytes(ResourceSyncInfo.setKeywordMode(syncBytes, toKSubst), 0);
                        continue;
                    }
                    if (ResourceSyncInfo.isDeletion(syncBytes)) continue;
                    if (fromKSubst.isBinary() && !toKSubst.isBinary()) {
                        CVSTeamProvider.cleanLineDelimiters(file, useCRLF, (IProgressMonitor)new NullProgressMonitor());
                        filesToCommitAsText.add(mFile);
                    }
                    CVSTeamProvider.makeDirty(file);
                    filesToCommit.add(mFile);
                    ArrayList<ICVSFile> list = (ArrayList<ICVSFile>)filesToAdmin.get(toKSubst);
                    if (list == null) {
                        list = new ArrayList<ICVSFile>();
                        filesToAdmin.put(toKSubst, list);
                    }
                    list.add(mFile);
                }
                int totalWork = filesToCommit.size() + 1;
                Iterator<Object> it2 = filesToAdmin.values().iterator();
                while (it2.hasNext()) {
                    List list = (List)it2.next();
                    totalWork += list.size();
                    ++totalWork;
                }
                if (totalWork != 0) {
                    monitor.beginTask(Policy.bind("CVSTeamProvider.settingKSubst"), totalWork);
                    try {
                        if (filesToCommit.size() != 0) {
                            Session session = new Session(CVSTeamProvider.this.workspaceRoot.getRemoteLocation(), CVSTeamProvider.this.workspaceRoot.getLocalRoot(), true);
                            session.open(Policy.subMonitorFor(monitor, 1), true);
                            try {
                                String keywordChangeComment = comment;
                                if (keywordChangeComment == null || keywordChangeComment.length() == 0) {
                                    keywordChangeComment = Policy.bind("CVSTeamProvider.changingKeywordComment");
                                }
                                result[0] = Command.COMMIT.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Commit.DO_NOT_RECURSE, Commit.FORCE, Commit.makeArgumentOption(Command.MESSAGE_OPTION, keywordChangeComment)}, filesToCommit.toArray(new ICVSResource[filesToCommit.size()]), filesToCommitAsText, null, Policy.subMonitorFor(monitor, filesToCommit.size()));
                            }
                            finally {
                                session.close();
                            }
                            if (!result[0].isOK()) {
                                return;
                            }
                        }
                        it2 = filesToAdmin.entrySet().iterator();
                        while (it2.hasNext()) {
                            Map.Entry entry = (Map.Entry)it2.next();
                            toKSubst = (Command.KSubstOption)entry.getKey();
                            List list = (List)entry.getValue();
                            Session session = new Session(CVSTeamProvider.this.workspaceRoot.getRemoteLocation(), CVSTeamProvider.this.workspaceRoot.getLocalRoot(), true);
                            session.open(Policy.subMonitorFor(monitor, 1), true);
                            try {
                                result[0] = Command.ADMIN.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{toKSubst}, list.toArray(new ICVSResource[list.size()]), (ICommandOutputListener)new AdminKSubstListener(toKSubst), Policy.subMonitorFor(monitor, list.size()));
                            }
                            finally {
                                session.close();
                            }
                            if (result[0].isOK()) continue;
                            return;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        }, Policy.monitorFor(monitor));
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanLineDelimiters(IFile file, boolean useCRLF, IProgressMonitor progress) throws CVSException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedInputStream is = new BufferedInputStream(file.getContents());
            try {
                int b;
                is = new CRLFtoLFInputStream((InputStream)is);
                if (useCRLF) {
                    is = new LFtoCRLFInputStream((InputStream)is);
                }
                while ((b = ((InputStream)is).read()) != -1) {
                    bos.write(b);
                }
                bos.close();
            }
            finally {
                ((InputStream)is).close();
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            file.setContents((InputStream)bis, false, false, progress);
        }
        catch (CoreException e) {
            throw CVSException.wrapException((IResource)file, Policy.bind("CVSTeamProvider.cleanLineDelimitersException"), e);
        }
        catch (IOException e) {
            throw CVSException.wrapException((IResource)file, Policy.bind("CVSTeamProvider.cleanLineDelimitersException"), e);
        }
    }

    private static void makeDirty(IFile file) throws CVSException {
        ICVSFile mFile = CVSWorkspaceRoot.getCVSFileFor(file);
        ResourceSyncInfo origInfo = mFile.getSyncInfo();
        MutableResourceSyncInfo info = origInfo.cloneMutable();
        info.setTimeStamp(null);
        mFile.setSyncInfo(info, 0);
    }

    public String getID() {
        return CVSProviderPlugin.getTypeId();
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return moveDeleteHook;
    }

    public static MoveDeleteHook getRegisteredMoveDeleteHook() {
        return moveDeleteHook;
    }

    public IFileModificationValidator getFileModificationValidator() {
        if (fileModificationValidator == null && (fileModificationValidator = CVSTeamProvider.getPluggedInValidator()) == null) {
            fileModificationValidator = super.getFileModificationValidator();
        }
        return fileModificationValidator;
    }

    public void edit(IResource[] resources, boolean recurse, boolean notifyServer, final int notification, IProgressMonitor progress) throws CVSException {
        this.notifyEditUnedit(resources, recurse, notifyServer, new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (file.isReadOnly()) {
                    file.edit(notification, Policy.monitorFor(null));
                }
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
            }
        }, null, progress);
    }

    public void unedit(IResource[] resources, boolean recurse, boolean notifyServer, IProgressMonitor progress) throws CVSException {
        this.notifyEditUnedit(resources, recurse, notifyServer, new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (!file.isReadOnly()) {
                    file.unedit(Policy.monitorFor(null));
                }
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
            }
        }, (ISchedulingRule)this.getProject(), progress);
    }

    private void notifyEditUnedit(final IResource[] resources, final boolean recurse, final boolean notifyServer, final ICVSResourceVisitor editUneditVisitor, ISchedulingRule rule, IProgressMonitor monitor) throws CVSException {
        final CVSException[] exception = new CVSException[]{null};
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSResource[] cvsResources = CVSTeamProvider.this.getCVSArguments(resources);
                try {
                    for (int i = 0; i < cvsResources.length; ++i) {
                        cvsResources[i].accept(editUneditVisitor, recurse);
                    }
                }
                catch (CVSException e) {
                    exception[0] = e;
                    return;
                }
                if (notifyServer) {
                    monitor.beginTask(null, 100);
                    Session session = new Session(CVSTeamProvider.this.workspaceRoot.getRemoteLocation(), CVSTeamProvider.this.workspaceRoot.getLocalRoot(), true);
                    try {
                        try {
                            session.open(Policy.subMonitorFor(monitor, 10), true);
                        }
                        catch (CVSException e1) {
                            session.close();
                            monitor.done();
                            return;
                        }
                        Command.NOOP.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, cvsResources, null, Policy.subMonitorFor(monitor, 90));
                    }
                    catch (CVSException e) {
                        exception[0] = e;
                    }
                    finally {
                        session.close();
                        monitor.done();
                    }
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, rule, 0, Policy.monitorFor(monitor));
        }
        catch (CoreException e) {
            if (exception[0] == null) {
                throw CVSException.wrapException(e);
            }
            CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e)));
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public boolean getFetchAbsentDirectories() throws CVSException {
        try {
            String property = this.getProject().getPersistentProperty(FETCH_ABSENT_DIRECTORIES_PROP_KEY);
            if (property == null) {
                return CVSProviderPlugin.getPlugin().getFetchAbsentDirectories();
            }
            return Boolean.valueOf(property);
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.errorGettingFetchProperty", this.project.getName()), e));
        }
    }

    public void setFetchAbsentDirectories(boolean fetchAbsentDirectories) throws CVSException {
        this.internalSetFetchAbsentDirectories(fetchAbsentDirectories ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public void internalSetFetchAbsentDirectories(String fetchAbsentDirectories) throws CVSException {
        try {
            this.getProject().setPersistentProperty(FETCH_ABSENT_DIRECTORIES_PROP_KEY, fetchAbsentDirectories);
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.errorSettingFetchProperty", this.project.getName()), e));
        }
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    public IStatus validateCreateLink(IResource resource, int updateFlags, IPath location) {
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource.getParent().getFolder((IPath)new Path(resource.getName())));
        try {
            if (cvsFolder.isCVSFolder()) {
                return new CVSStatus(4, Policy.bind("CVSTeamProvider.overlappingRemoteFolder", resource.getFullPath().toString()));
            }
            ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor(resource.getParent().getFile((IPath)new Path(resource.getName())));
            if (cvsFile.isManaged()) {
                return new CVSStatus(4, Policy.bind("CVSTeamProvider.overlappingFileDeletion", resource.getFullPath().toString()));
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return e.getStatus();
        }
        return super.validateCreateLink(resource, updateFlags, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorsInfo[] editors(IResource[] resources, IProgressMonitor progress) throws CVSException {
        Command.LocalOption[] commandOptions = new Command.LocalOption[]{};
        progress.worked(10);
        String[] arguments = this.getValidArguments(resources, commandOptions);
        EditorsListener listener = new EditorsListener();
        if (progress.isCanceled()) {
            return new EditorsInfo[0];
        }
        Session session = new Session(this.workspaceRoot.getRemoteLocation(), this.workspaceRoot.getLocalRoot());
        if (progress.isCanceled()) {
            return new EditorsInfo[0];
        }
        progress.beginTask(null, 100);
        try {
            session.open(Policy.subMonitorFor(progress, 20), false);
            if (!progress.isCanceled()) {
                Command.EDITORS.execute(session, Command.NO_GLOBAL_OPTIONS, commandOptions, arguments, (ICommandOutputListener)listener, Policy.subMonitorFor(progress, 80));
            }
        }
        finally {
            session.close();
            progress.done();
        }
        return listener.getEditorsInfos();
    }

    public String getCommitTemplate() throws CVSException {
        ICVSFolder localFolder = this.getCVSWorkspaceRoot().getLocalRoot();
        ICVSFile templateFile = CVSWorkspaceRoot.getCVSFileFor(SyncFileWriter.getTemplateFile((IContainer)localFolder.getIResource()));
        if (!templateFile.exists()) {
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(templateFile.getContents());
        try {
            int b;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            do {
                if ((b = ((InputStream)in).read()) == -1) continue;
                out.write((byte)b);
            } while (b != -1);
            out.close();
            String string = new String(out.toString());
            return string;
        }
        catch (IOException e) {
            throw CVSException.wrapException(e);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e)));
            }
        }
    }

    public boolean isWatchEditEnabled() throws CVSException {
        IProject project = this.getProject();
        try {
            String property = (String)project.getSessionProperty(WATCH_EDIT_PROP_KEY);
            if (property == null) {
                property = project.getPersistentProperty(WATCH_EDIT_PROP_KEY);
                if (property == null) {
                    return CVSProviderPlugin.getPlugin().isWatchEditEnabled();
                }
                project.setSessionProperty(WATCH_EDIT_PROP_KEY, (Object)property);
            }
            return Boolean.valueOf(property);
        }
        catch (CoreException e) {
            if (project.isAccessible()) {
                throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.errorGettingWatchEdit", project.getName()), e));
            }
            return false;
        }
    }

    public void setWatchEditEnabled(boolean enabled) throws CVSException {
        this.internalSetWatchEditEnabled(enabled ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    private void internalSetWatchEditEnabled(String enabled) throws CVSException {
        try {
            IProject project = this.getProject();
            project.setPersistentProperty(WATCH_EDIT_PROP_KEY, enabled);
            project.setSessionProperty(WATCH_EDIT_PROP_KEY, (Object)enabled);
        }
        catch (CoreException e) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.errorSettingWatchEdit", this.project.getName()), e));
        }
    }

    public IResourceRuleFactory getRuleFactory() {
        return RESOURCE_RULE_FACTORY;
    }

    static {
        FETCH_ABSENT_DIRECTORIES_PROP_KEY = new QualifiedName("org.eclipse.team.cvs.core", "fetch_absent_directories");
        WATCH_EDIT_PROP_KEY = new QualifiedName("org.eclipse.team.cvs.core", "watch_edit");
    }
}

