/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.isite.ISiteDescription;
import org.eclipse.pde.internal.core.site.SiteObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteDescription
extends SiteObject
implements ISiteDescription {
    private String url;
    private String text;

    public String getURL() {
        return this.url;
    }

    public String getText() {
        return this.text;
    }

    public void setURL(String url) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.url;
        this.url = url;
        this.firePropertyChanged("url", oldValue, url);
    }

    public void setText(String text) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.text;
        this.text = text;
        this.firePropertyChanged("text", oldValue, text);
    }

    protected void reset() {
        this.url = null;
        this.text = null;
    }

    protected void parse(Node node, Hashtable lineTable) {
        this.url = this.getNodeAttribute(node, "url");
        this.bindSourceLocation(node, lineTable);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            Node firstChild = node.getFirstChild();
            if (firstChild == null) break;
            this.text = this.getNormalizedText(firstChild.getNodeValue());
            break;
        }
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("url")) {
            this.setURL(newValue != null ? newValue.toString() : null);
        } else if (name.equals("text")) {
            this.setText(newValue != null ? newValue.toString() : null);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(indent);
        writer.print("<description");
        if (this.url != null) {
            writer.print(" url=\"" + this.url + "\"");
        }
        writer.println(">");
        if (this.text != null) {
            writer.println(indent + "   " + this.getNormalizedText(this.text));
        }
        writer.println(indent + "</description>");
    }

    public boolean isValid() {
        return true;
    }
}

