/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupMessages;

public abstract class CompositeSourceContainer
extends AbstractSourceContainer {
    private ISourceContainer[] fContainers;

    public boolean isComposite() {
        return true;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        return this.findSourceElements(name, this.getSourceContainers());
    }

    protected Object[] findSourceElements(String name, ISourceContainer[] containers) throws CoreException {
        ArrayList<Object> results = null;
        CoreException single = null;
        MultiStatus multiStatus = null;
        if (this.isFindDuplicates()) {
            results = new ArrayList<Object>();
        }
        for (int i = 0; i < containers.length; ++i) {
            ISourceContainer container = containers[i];
            try {
                Object[] objects = container.findSourceElements(name);
                if (objects.length <= 0) continue;
                if (this.isFindDuplicates()) {
                    for (int j = 0; j < objects.length; ++j) {
                        results.add(objects[j]);
                    }
                    continue;
                }
                if (objects.length == 1) {
                    return objects;
                }
                return new Object[]{objects[0]};
            }
            catch (CoreException e) {
                if (single == null) {
                    single = e;
                    continue;
                }
                if (multiStatus == null) {
                    multiStatus = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 120, new IStatus[]{single.getStatus()}, SourceLookupMessages.getString("CompositeSourceContainer.0"), null);
                    multiStatus.add(e.getStatus());
                    continue;
                }
                multiStatus.add(e.getStatus());
            }
        }
        if (results == null) {
            if (multiStatus != null) {
                throw new CoreException(multiStatus);
            }
            if (single != null) {
                throw single;
            }
            return EMPTY;
        }
        return results.toArray();
    }

    protected abstract ISourceContainer[] createSourceContainers() throws CoreException;

    public synchronized ISourceContainer[] getSourceContainers() throws CoreException {
        if (this.fContainers == null) {
            this.fContainers = this.createSourceContainers();
            for (int i = 0; i < this.fContainers.length; ++i) {
                ISourceContainer container = this.fContainers[i];
                container.init(this.getDirector());
            }
        }
        return this.fContainers;
    }

    public void dispose() {
        super.dispose();
        if (this.fContainers != null) {
            for (int i = 0; i < this.fContainers.length; ++i) {
                ISourceContainer container = this.fContainers[i];
                container.dispose();
            }
        }
        this.fContainers = null;
    }
}

