/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.swt.graphics.Image;

public class UnimplementedMethodsCompletionProposal
extends ASTRewriteCorrectionProposal {
    private ASTNode fTypeNode;
    private IMethodBinding[] fMethodsToOverride;

    public UnimplementedMethodsCompletionProposal(ICompilationUnit cu, ASTNode typeNode, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.setDisplayName(CorrectionMessages.getString("UnimplementedMethodsCompletionProposal.description"));
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fTypeNode = typeNode;
        this.fMethodsToOverride = null;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ListRewrite listRewrite;
        ITypeBinding binding;
        AnonymousClassDeclaration decl;
        AST ast = this.fTypeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (this.fTypeNode instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fTypeNode;
            binding = decl.resolveBinding();
            listRewrite = rewrite.getListRewrite((ASTNode)decl, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
        } else {
            decl = (TypeDeclaration)this.fTypeNode;
            binding = decl.resolveBinding();
            listRewrite = rewrite.getListRewrite((ASTNode)decl, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        }
        IMethodBinding[] methods = this.evalUnimplementedMethods(binding);
        this.fMethodsToOverride = methods;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (!settings.createComments || binding.isAnonymous()) {
            settings = null;
        }
        for (int i = 0; i < methods.length; ++i) {
            MethodDeclaration newMethodDecl = this.createNewMethodDeclaration(ast, methods[i], rewrite, binding.getName(), settings);
            listRewrite.insertLast((ASTNode)newMethodDecl, null);
        }
        return rewrite;
    }

    private MethodDeclaration createNewMethodDeclaration(AST ast, IMethodBinding binding, ASTRewrite rewrite, String typeName, CodeGenerationSettings commentSettings) throws CoreException {
        String string;
        String placeHolder;
        ImportRewrite imports = this.getImportRewrite();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setModifiers(binding.getModifiers() & 0xFFFFFBFF);
        decl.setName(ast.newSimpleName(binding.getName()));
        decl.setConstructor(false);
        String returnTypeName = imports.addImport(binding.getReturnType());
        decl.setReturnType(ASTNodeFactory.newType(ast, returnTypeName));
        List parameters = decl.parameters();
        ITypeBinding[] params = binding.getParameterTypes();
        String[] paramNames = this.getArgumentNames(binding);
        for (int i = 0; i < params.length; ++i) {
            String paramTypeName = imports.addImport(params[i]);
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            var.setType(ASTNodeFactory.newType(ast, paramTypeName));
            var.setName(ast.newSimpleName(paramNames[i]));
            parameters.add(var);
        }
        List thrownExceptions = decl.thrownExceptions();
        ITypeBinding[] excTypes = binding.getExceptionTypes();
        for (int i = 0; i < excTypes.length; ++i) {
            String excTypeName = imports.addImport(excTypes[i]);
            thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
        }
        Block body = ast.newBlock();
        decl.setBody(body);
        String bodyStatement = "";
        Expression expression = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType(), decl.getExtraDimensions());
        if (expression != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, String.valueOf('\n'));
        }
        if ((placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), typeName, binding.getName(), false, bodyStatement, String.valueOf('\n'))) != null) {
            ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
            body.statements().add(todoNode);
        }
        if (commentSettings != null && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), typeName, decl, binding, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private String[] getArgumentNames(IMethodBinding binding) {
        int nParams = binding.getParameterTypes().length;
        if (nParams > 0) {
            try {
                IJavaProject project = this.getCompilationUnit().getJavaProject();
                IMethod method = Bindings.findMethod(binding, project);
                if (method != null) {
                    return StubUtility.suggestArgumentNames(project, method.getParameterNames());
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        String[] names = new String[nParams];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "arg" + i;
        }
        return names;
    }

    private void findUnimplementedInterfaceMethods(ITypeBinding typeBinding, HashSet visited, ArrayList allMethods, IPackageBinding currPack, ArrayList toImplement) {
        if (visited.add(typeBinding)) {
            IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
            for (int i = 0; i < typeMethods.length; ++i) {
                IMethodBinding curr = typeMethods[i];
                IMethodBinding impl = this.findMethod(curr, allMethods);
                if (impl != null && Bindings.isVisibleInHierarchy(impl, currPack) && (curr.getExceptionTypes().length >= impl.getExceptionTypes().length || Modifier.isFinal((int)impl.getModifiers()))) continue;
                if (impl != null) {
                    allMethods.remove(impl);
                }
                toImplement.add(curr);
                allMethods.add(curr);
            }
            ITypeBinding[] superInterfaces = typeBinding.getInterfaces();
            for (int i = 0; i < superInterfaces.length; ++i) {
                this.findUnimplementedInterfaceMethods(superInterfaces[i], visited, allMethods, currPack, toImplement);
            }
        }
    }

    private IMethodBinding[] evalUnimplementedMethods(ITypeBinding typeBinding) {
        int modifiers;
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        ArrayList<IMethodBinding> toImplement = new ArrayList<IMethodBinding>();
        IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
        for (int i = 0; i < typeMethods.length; ++i) {
            IMethodBinding curr = typeMethods[i];
            int modifiers2 = curr.getModifiers();
            if (curr.isConstructor() || Modifier.isStatic((int)modifiers2) || Modifier.isPrivate((int)modifiers2)) continue;
            allMethods.add(curr);
        }
        for (ITypeBinding superClass = typeBinding.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            typeMethods = superClass.getDeclaredMethods();
            for (int i = 0; i < typeMethods.length; ++i) {
                IMethodBinding curr = typeMethods[i];
                modifiers = curr.getModifiers();
                if (curr.isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || this.findMethod(curr, allMethods) != null) continue;
                allMethods.add(curr);
            }
        }
        for (int i = 0; i < allMethods.size(); ++i) {
            IMethodBinding curr = (IMethodBinding)allMethods.get(i);
            modifiers = curr.getModifiers();
            if (!Modifier.isAbstract((int)modifiers) && !curr.getDeclaringClass().isInterface() || typeBinding == curr.getDeclaringClass()) continue;
            toImplement.add(curr);
        }
        HashSet visited = new HashSet();
        for (ITypeBinding curr = typeBinding; curr != null; curr = curr.getSuperclass()) {
            ITypeBinding[] superInterfaces = curr.getInterfaces();
            for (int i = 0; i < superInterfaces.length; ++i) {
                this.findUnimplementedInterfaceMethods(superInterfaces[i], visited, allMethods, typeBinding.getPackage(), toImplement);
            }
        }
        return toImplement.toArray(new IMethodBinding[toImplement.size()]);
    }

    private IMethodBinding findMethod(IMethodBinding method, ArrayList allMethods) {
        for (int i = 0; i < allMethods.size(); ++i) {
            IMethodBinding curr = (IMethodBinding)allMethods.get(i);
            if (!Bindings.isEqualMethod(method, curr.getName(), curr.getParameterTypes())) continue;
            return curr;
        }
        return null;
    }

    public String getAdditionalProposalInfo() {
        try {
            this.initializeTextChange();
            StringBuffer buf = new StringBuffer();
            buf.append("<b>");
            buf.append(CorrectionMessages.getFormattedString("UnimplementedMethodsCompletionProposal.info", String.valueOf(this.fMethodsToOverride.length)));
            buf.append("</b><ul>");
            for (int i = 0; i < this.fMethodsToOverride.length; ++i) {
                buf.append("<li>");
                buf.append(Bindings.asString((IBinding)this.fMethodsToOverride[i]));
                buf.append("</li>");
            }
            buf.append("</ul>");
            return buf.toString();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return null;
        }
    }
}

