/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.search.internal.core.text.TextSearchScope;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class QualifiedNameFinder {
    public static void process(QualifiedNameSearchResult result, String pattern, String newValue, String filePatterns, IProject root, IProgressMonitor monitor) throws JavaModelException {
        if (filePatterns == null || filePatterns.length() == 0) {
            monitor.beginTask("", 1);
            monitor.worked(1);
            return;
        }
        Assert.isNotNull(pattern);
        Assert.isNotNull(newValue);
        Assert.isNotNull(root);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ResultCollector collector = new ResultCollector(result, newValue, monitor);
        TextSearchEngine engine = new TextSearchEngine();
        engine.search(ResourcesPlugin.getWorkspace(), (ISearchScope)QualifiedNameFinder.createScope(filePatterns, root), false, (ITextSearchResultCollector)collector, new MatchLocator(pattern, true, false));
    }

    private static TextSearchScope createScope(String filePatterns, IProject root) throws JavaModelException {
        String[] patterns = QualifiedNameFinder.splitFilePatterns(filePatterns);
        TextSearchScope result = new TextSearchScope("");
        result.add((IResource)root);
        QualifiedNameFinder.addReferencingProjects(result, root);
        for (int i = 0; i < patterns.length; ++i) {
            result.addExtension(patterns[i]);
        }
        return result;
    }

    private static String[] splitFilePatterns(String filePatterns) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(filePatterns, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result.toArray(new String[result.size()]);
    }

    private static void addReferencingProjects(TextSearchScope scope, IProject root) {
        IProject[] projects = root.getReferencingProjects();
        for (int i = 0; i < projects.length; ++i) {
            IProject project = projects[i];
            if (scope.encloses((IResource)project)) continue;
            scope.add((IResource)project);
            QualifiedNameFinder.addReferencingProjects(scope, project);
        }
    }

    private static class ResultCollector
    implements ITextSearchResultCollector {
        private String fNewValue;
        private IProgressMonitor fProgressMonitor;
        private QualifiedNameSearchResult fResult;

        public ResultCollector(QualifiedNameSearchResult result, String newValue, IProgressMonitor monitor) {
            this.fResult = result;
            this.fNewValue = newValue;
            this.fProgressMonitor = monitor;
        }

        public void aboutToStart() throws CoreException {
        }

        public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) throws CoreException {
            if (proxy.getType() != 1) {
                return;
            }
            IFile file = (IFile)proxy.requestResource();
            IJavaElement element = JavaCore.create((IFile)file);
            if (element != null && element.exists()) {
                return;
            }
            TextChange change = this.fResult.getChange(file);
            TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("QualifiedNameFinder.update_name"), (TextEdit)new ReplaceEdit(start, length, this.fNewValue));
        }

        public void done() throws CoreException {
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }
    }
}

