/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class GlobalBuildAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private int buildType;
    private IWorkbenchWindow workbenchWindow;

    public GlobalBuildAction(IWorkbench workbench, Shell shell, int type) {
        this(workbench.getActiveWorkbenchWindow(), type);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
    }

    public GlobalBuildAction(IWorkbenchWindow window, int type) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setBuildType(type);
    }

    private void setBuildType(int type) {
        switch (type) {
            case 9: 
            case 10: {
                this.setText(IDEWorkbenchMessages.getString("GlobalBuildAction.text"));
                this.setToolTipText(IDEWorkbenchMessages.getString("GlobalBuildAction.toolTip"));
                this.setId("build");
                WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.global_incremental_build_action_context");
                this.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC"));
                this.setDisabledImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC_DISABLED"));
                this.setActionDefinitionId("org.eclipse.ui.project.buildAll");
                break;
            }
            case 6: {
                this.setText(IDEWorkbenchMessages.getString("GlobalBuildAction.rebuildText"));
                this.setToolTipText(IDEWorkbenchMessages.getString("GlobalBuildAction.rebuildToolTip"));
                this.setId("rebuildAll");
                WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.global_full_build_action_context");
                this.setActionDefinitionId("org.eclipse.ui.project.rebuildAll");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid build type");
            }
        }
        this.buildType = type;
    }

    private Shell getShell() {
        return this.workbenchWindow.getShell();
    }

    private String getOperationMessage() {
        if (this.buildType == 10) {
            return IDEWorkbenchMessages.getString("GlobalBuildAction.buildOperationTitle");
        }
        return IDEWorkbenchMessages.getString("GlobalBuildAction.rebuildAllOperationTitle");
    }

    public void doBuild() {
        this.doBuildOperation();
    }

    void doBuildOperation() {
        Job buildJob = new Job(IDEWorkbenchMessages.getString("GlobalBuildAction.jobTitle")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                MultiStatus status = new MultiStatus("org.eclipse.ui", 0, IDEWorkbenchMessages.getString("GlobalBuildAction.buildProblems"), null);
                monitor.beginTask(GlobalBuildAction.this.getOperationMessage(), 100);
                try {
                    ResourcesPlugin.getWorkspace().build(GlobalBuildAction.this.buildType, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
                finally {
                    monitor.done();
                }
                return status;
            }

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        buildJob.schedule();
    }

    IProject[] getWorkspaceProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        IProject[] roots = this.getWorkspaceProjects();
        if (roots.length < 1) {
            return;
        }
        if (!this.verifyBuildersAvailable(roots)) {
            return;
        }
        if (!this.verifyNoManualRunning()) {
            return;
        }
        this.saveAllResources();
        this.doBuildOperation();
    }

    void saveAllResources() {
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        for (int i = 0; i < windows.length; ++i) {
            IWorkbenchPage[] perspectives = windows[i].getPages();
            for (int j = 0; j < perspectives.length; ++j) {
                perspectives[j].saveAllEditors(false);
            }
        }
    }

    boolean verifyBuildersAvailable(IProject[] roots) {
        try {
            for (int i = 0; i < roots.length; ++i) {
                if (!roots[i].isAccessible() || roots[i].getDescription().getBuildSpec().length <= 0) continue;
                return true;
            }
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log("Exception in " + ((Object)((Object)this)).getClass().getName() + ".run: " + (Object)((Object)e));
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.getString("GlobalBuildAction.buildProblems"), (String)IDEWorkbenchMessages.format("GlobalBuildAction.internalError", new Object[]{e.getMessage()}), (IStatus)e.getStatus());
            return false;
        }
        return false;
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }

    private boolean verifyNoManualRunning() {
        Job[] buildJobs = JobManager.getInstance().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
        if (buildJobs.length == 0) {
            return true;
        }
        boolean cancel = MessageDialog.openQuestion((Shell)this.workbenchWindow.getShell(), (String)IDEWorkbenchMessages.getString("GlobalBuildAction.BuildRunningTitle"), (String)IDEWorkbenchMessages.getString("GlobalBuildAction.BuildRunningMessage"));
        if (cancel) {
            for (int i = 0; i < buildJobs.length; ++i) {
                Job job = buildJobs[i];
                job.cancel();
            }
        }
        return false;
    }
}

