/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.AbstractViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.help.WorkbenchHelp;

public class BinaryCompareViewer
extends AbstractViewer {
    private static final String BUNDLE_NAME = "org.eclipse.compare.internal.BinaryCompareViewerResources";
    private static final int EOF = -1;
    private Label fControl;
    private ICompareInput fInput;
    private ResourceBundle fBundle;
    private boolean fLeftIsLocal;

    public BinaryCompareViewer(Composite parent, CompareConfiguration cc) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.compare.binary_compare_view_context");
        this.fBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this.fControl = new Label(parent, 64);
        this.fControl.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Utilities.getString(this.fBundle, "title"));
        this.fLeftIsLocal = Utilities.getBoolean(cc, "LEFT_IS_LOCAL", false);
    }

    public Control getControl() {
        return this.fControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setInput(Object input) {
        block15: {
            String message;
            InputStream right;
            InputStream left;
            block14: {
                if (this.fControl == null || !(input instanceof ICompareInput)) break block15;
                this.fInput = (ICompareInput)input;
                left = null;
                right = null;
                message = null;
                try {
                    left = this.getStream(this.fInput.getLeft());
                    right = this.getStream(this.fInput.getRight());
                    if (left != null && right != null) {
                        int pos = 0;
                        while (true) {
                            int r;
                            int l;
                            if ((l = left.read()) != (r = right.read())) {
                                String format = Utilities.getString(this.fBundle, "diffMessageFormat");
                                message = MessageFormat.format(format, Integer.toString(pos));
                            } else if (l != -1) {
                                ++pos;
                                continue;
                            }
                            break block14;
                            break;
                        }
                    }
                    if (left == null && right == null) {
                        message = Utilities.getString(this.fBundle, "deleteConflictMessage");
                        break block14;
                    }
                    if (left == null) {
                        message = this.fLeftIsLocal ? Utilities.getString(this.fBundle, "deletedMessage") : Utilities.getString(this.fBundle, "addedMessage");
                        break block14;
                    }
                    if (right != null) break block14;
                    message = this.fLeftIsLocal ? Utilities.getString(this.fBundle, "addedMessage") : Utilities.getString(this.fBundle, "deletedMessage");
                }
                catch (CoreException ex) {
                    message = Utilities.getString(this.fBundle, "errorMessage");
                    Utilities.close(left);
                    Utilities.close(right);
                }
                catch (IOException ex2) {
                    message = Utilities.getString(this.fBundle, "errorMessage");
                    {
                        catch (Throwable throwable) {
                            Utilities.close(left);
                            Utilities.close(right);
                            throw throwable;
                        }
                    }
                    Utilities.close(left);
                    Utilities.close(right);
                }
            }
            Utilities.close(left);
            Utilities.close(right);
            if (message != null) {
                this.fControl.setText(message);
            }
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    private InputStream getStream(ITypedElement input) throws CoreException {
        if (input instanceof IStreamContentAccessor) {
            return ((IStreamContentAccessor)((Object)input)).getContents();
        }
        return null;
    }
}

