/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.editors.text.JavaFileEditorInput;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.part.FileEditorInput;

public class OpenExternalFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public OpenExternalFileAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private File queryFile() {
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 4096);
        dialog.setText(TextEditorMessages.getString("OpenExternalFileAction.dialog.text"));
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            return new File(path);
        }
        return null;
    }

    public void run() {
        File file = this.queryFile();
        if (file != null && file.exists()) {
            IEditorInput input = this.createEditorInput(file);
            String editorId = this.getEditorId(file);
            IWorkbenchPage page = this.fWindow.getActivePage();
            try {
                page.openEditor(input, editorId);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        } else if (file != null) {
            String msgFmt = TextEditorMessages.getString("OpenExternalFileAction.FileNotFound");
            String msg = MessageFormat.format(msgFmt, file.getName());
            MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)TextEditorMessages.getString("OpenExternalFileAction.dialog.text"), (String)msg);
        }
    }

    private String getEditorId(File file) {
        IWorkbench workbench = this.fWindow.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private IEditorInput createEditorInput(File file) {
        IFile workspaceFile = this.getWorkspaceFile(file);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new JavaFileEditorInput(file);
    }

    private IFile getWorkspaceFile(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path location = new Path(file.getAbsolutePath());
        IFile[] files = workspace.getRoot().findFilesForLocation((IPath)location);
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        return this.selectWorkspaceFile(files);
    }

    private IFile selectWorkspaceFile(IFile[] files) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.fWindow.getShell(), (ILabelProvider)new FileLabelProvider());
        dialog.setElements((Object[])files);
        dialog.setTitle(TextEditorMessages.getString("OpenExternalFileAction.SelectWorkspaceFile"));
        dialog.setMessage(TextEditorMessages.getString("OpenExternalFileAction.FileLinkedtoMultiple"));
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IPath path = ((IFile)element).getFullPath();
                return path != null ? path.toString() : "";
            }
            return super.getText(element);
        }
    }
}

