/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.embedded;

import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.ui.internal.browser.embedded.EmbeddedBrowser;
import org.eclipse.swt.widgets.Display;

public class EmbeddedBrowserAdapter
implements IBrowser {
    private EmbeddedBrowser browser;

    public synchronized void displayURL(final String url) {
        Display defaultDisplay = Display.getDefault();
        if (defaultDisplay == Display.getCurrent()) {
            this.uiDisplayURL(url);
        } else {
            defaultDisplay.syncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiDisplayURL(url);
                }
            });
        }
    }

    private void uiDisplayURL(String url) {
        this.uiClose();
        this.getBrowser().displayUrl(url);
    }

    public void close() {
        Display defaultDisplay = Display.getDefault();
        if (defaultDisplay == Display.getCurrent()) {
            this.uiClose();
        } else {
            defaultDisplay.syncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiClose();
                }
            });
        }
    }

    private void uiClose() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.close();
        }
    }

    private EmbeddedBrowser getBrowser() {
        if (this.browser == null || this.browser.isDisposed()) {
            this.browser = new EmbeddedBrowser();
        }
        return this.browser;
    }

    public boolean isCloseSupported() {
        return true;
    }

    public boolean isSetLocationSupported() {
        return true;
    }

    public boolean isSetSizeSupported() {
        return true;
    }

    public void setLocation(final int x, final int y) {
        Display defaultDisplay = Display.getDefault();
        if (defaultDisplay == Display.getCurrent()) {
            this.uiSetLocation(x, y);
        } else {
            defaultDisplay.syncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiSetLocation(x, y);
                }
            });
        }
    }

    private void uiSetLocation(int x, int y) {
        this.getBrowser().setLocation(x, y);
    }

    public void setSize(final int width, final int height) {
        Display defaultDisplay = Display.getDefault();
        if (defaultDisplay == Display.getCurrent()) {
            this.uiSetSize(width, height);
        } else {
            defaultDisplay.syncExec(new Runnable(){

                public void run() {
                    EmbeddedBrowserAdapter.this.uiSetSize(width, height);
                }
            });
        }
    }

    private void uiSetSize(int width, int height) {
        this.getBrowser().setSize(width, height);
    }
}

