/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.internal.console.ConsoleMessages;

public abstract class AbstractConsole
implements IConsole {
    private ListenerList fListeners;
    private String fName = null;
    private ImageDescriptor fImageDescriptor = null;

    public AbstractConsole(String name, ImageDescriptor imageDescriptor) {
        this.setName(name);
        this.setImageDescriptor(imageDescriptor);
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(new Lifecycle());
    }

    public String getName() {
        return this.fName;
    }

    protected void setName(String name) {
        String old = this.fName;
        this.fName = name;
        this.firePropertyChange(this, "org.eclipse.jface.text", old, name);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fImageDescriptor;
    }

    protected void setImageDescriptor(ImageDescriptor imageDescriptor) {
        ImageDescriptor old = this.fImageDescriptor;
        this.fImageDescriptor = imageDescriptor;
        this.firePropertyChange(this, "org.eclipse.jface.image", old, imageDescriptor);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public void firePropertyChange(Object source, String property, Object oldValue, Object newValue) {
        if (this.fListeners == null) {
            return;
        }
        PropertyNotifier notifier = new PropertyNotifier();
        notifier.notify(new PropertyChangeEvent(source, property, oldValue, newValue));
    }

    protected void init() {
    }

    protected void dispose() {
    }

    class PropertyNotifier
    implements ISafeRunnable {
        private IPropertyChangeListener fListener;
        private PropertyChangeEvent fEvent;

        PropertyNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, ConsoleMessages.getString("AbstractConsole.0"), exception);
            ConsolePlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            this.fListener.propertyChange(this.fEvent);
        }

        public void notify(PropertyChangeEvent event) {
            if (AbstractConsole.this.fListeners == null) {
                return;
            }
            this.fEvent = event;
            Object[] copiedListeners = AbstractConsole.this.fListeners.getListeners();
            for (int i = 0; i < copiedListeners.length; ++i) {
                this.fListener = (IPropertyChangeListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
            }
            this.fListener = null;
        }
    }

    class Lifecycle
    implements IConsoleListener {
        Lifecycle() {
        }

        public void consolesAdded(IConsole[] consoles) {
            for (int i = 0; i < consoles.length; ++i) {
                IConsole console = consoles[i];
                if (console != AbstractConsole.this) continue;
                AbstractConsole.this.init();
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            for (int i = 0; i < consoles.length; ++i) {
                IConsole console = consoles[i];
                if (console != AbstractConsole.this) continue;
                ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener(this);
                AbstractConsole.this.dispose();
            }
        }
    }
}

