/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.c;
import com.google.android.gms.internal.db;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.en;

public final class PlayerEntity
extends en
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new a();
    private final int iM;
    private final String mD;
    private final String ml;
    private final Uri mq;
    private final Uri mr;
    private final long mE;

    public PlayerEntity(Player player) {
        this.iM = 1;
        this.mD = player.getPlayerId();
        this.ml = player.getDisplayName();
        this.mq = player.getIconImageUri();
        this.mr = player.getHiResImageUri();
        this.mE = player.getRetrievedTimestamp();
        db.c(this.mD);
        db.c(this.ml);
        db.k(this.mE > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp) {
        this.iM = versionCode;
        this.mD = playerId;
        this.ml = displayName;
        this.mq = iconImageUri;
        this.mr = hiResImageUri;
        this.mE = retrievedTimestamp;
    }

    public int getVersionCode() {
        return this.iM;
    }

    public String getPlayerId() {
        return this.mD;
    }

    public String getDisplayName() {
        return this.ml;
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        eg.b(this.ml, dataOut);
    }

    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    public Uri getIconImageUri() {
        return this.mq;
    }

    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    public Uri getHiResImageUri() {
        return this.mr;
    }

    public long getRetrievedTimestamp() {
        return this.mE;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.a(this);
    }

    static int a(Player player) {
        return dl.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return dl.equal(player2.getPlayerId(), player.getPlayerId()) && dl.equal(player2.getDisplayName(), player.getDisplayName()) && dl.equal(player2.getIconImageUri(), player.getIconImageUri()) && dl.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && dl.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp());
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    static String b(Player player) {
        return dl.d(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("HiResImageUri", player.getHiResImageUri()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.aX()) {
            c.a(this, dest, flags);
        } else {
            dest.writeString(this.mD);
            dest.writeString(this.ml);
            dest.writeString(this.mq == null ? null : this.mq.toString());
            dest.writeString(this.mr == null ? null : this.mr.toString());
            dest.writeLong(this.mE);
        }
    }

    static final class a
    extends c {
        a() {
        }

        public PlayerEntity u(Parcel parcel) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.aW());
            if (bl2 || PlayerEntity.y(PlayerEntity.class.getCanonicalName())) {
                return super.u(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            long l2 = parcel.readLong();
            return new PlayerEntity(1, string2, string3, uri, uri2, l2);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.u(x0);
        }
    }
}

