#ifndef _ISO_88591_40_H_
#define _ISO_88591_40_H_
#include <devfont.h>

#define GAPS_BETWEEN_CHARACTER	1
#define TOTAL_CHARACTER_NUM 104

static const FONTINDEX ISO_88591_40_font_map[TOTAL_CHARACTER_NUM] = {
{0x001A,0x15,0x0000},
{0x001B,0x15,0x0069},
{0x001C,0x01,0x00D2},
{0x001D,0x01,0x00D7},
{0x001E,0x01,0x00DC},
{0x001F,0x01,0x00E1},
{0x0020,0x01,0x00E6},
{0x0021,0x08,0x00EB},
{0x0022,0x0B,0x0113},
{0x0023,0x12,0x014A},
{0x0024,0x12,0x01A4},
{0x0025,0x1B,0x01FE},
{0x0026,0x14,0x0285},
{0x0027,0x05,0x02E9},
{0x0028,0x0B,0x0302},
{0x0029,0x0A,0x0339},
{0x002A,0x0C,0x036B},
{0x002B,0x12,0x03A7},
{0x002C,0x07,0x0401},
{0x002D,0x0B,0x0424},
{0x002E,0x07,0x045B},
{0x002F,0x0A,0x047E},
{0x0030,0x12,0x04B0},
{0x0031,0x0D,0x050A},
{0x0032,0x11,0x054B},
{0x0033,0x12,0x05A0},
{0x0034,0x12,0x05FA},
{0x0035,0x12,0x0654},
{0x0036,0x12,0x06AE},
{0x0037,0x12,0x0708},
{0x0038,0x12,0x0762},
{0x0039,0x12,0x07BC},
{0x003A,0x07,0x0816},
{0x003B,0x07,0x0839},
{0x003C,0x12,0x085C},
{0x003D,0x12,0x08B6},
{0x003E,0x12,0x0910},
{0x003F,0x12,0x096A},
{0x0040,0x21,0x09C4},
{0x0041,0x16,0x0A69},
{0x0042,0x15,0x0AD7},
{0x0043,0x17,0x0B40},
{0x0044,0x17,0x0BB3},
{0x0045,0x14,0x0C26},
{0x0046,0x14,0x0C8A},
{0x0047,0x18,0x0CEE},
{0x0048,0x15,0x0D66},
{0x0049,0x07,0x0DCF},
{0x004A,0x0E,0x0DF2},
{0x004B,0x17,0x0E38},
{0x004C,0x12,0x0EAB},
{0x004D,0x19,0x0F05},
{0x004E,0x15,0x0F82},
{0x004F,0x19,0x0FEB},
{0x0050,0x15,0x1068},
{0x0051,0x19,0x10D1},
{0x0052,0x16,0x114E},
{0x0053,0x14,0x11BC},
{0x0054,0x14,0x1220},
{0x0055,0x15,0x1284},
{0x0056,0x16,0x12ED},
{0x0057,0x20,0x135B},
{0x0058,0x16,0x13FB},
{0x0059,0x16,0x1469},
{0x005A,0x14,0x14D7},
{0x005B,0x09,0x153B},
{0x005C,0x0B,0x1568},
{0x005D,0x08,0x159F},
{0x005E,0x0E,0x15C7},
{0x005F,0x13,0x160D},
{0x0060,0x08,0x166C},
{0x0061,0x11,0x1694},
{0x0062,0x11,0x16E9},
{0x0063,0x10,0x173E},
{0x0064,0x10,0x178E},
{0x0065,0x11,0x17DE},
{0x0066,0x0B,0x1833},
{0x0067,0x10,0x186A},
{0x0068,0x11,0x18BA},
{0x0069,0x06,0x190F},
{0x006A,0x06,0x192D},
{0x006B,0x11,0x194B},
{0x006C,0x06,0x19A0},
{0x006D,0x1A,0x19BE},
{0x006E,0x11,0x1A40},
{0x006F,0x11,0x1A95},
{0x0070,0x11,0x1AEA},
{0x0071,0x10,0x1B3F},
{0x0072,0x0C,0x1B8F},
{0x0073,0x10,0x1BCB},
{0x0074,0x09,0x1C1B},
{0x0075,0x11,0x1C48},
{0x0076,0x10,0x1C9D},
{0x0077,0x18,0x1CED},
{0x0078,0x0F,0x1D65},
{0x0079,0x10,0x1DB0},
{0x007A,0x0F,0x1E00},
{0x007B,0x0B,0x1E4B},
{0x007C,0x06,0x1E82},
{0x007D,0x0B,0x1EA0},
{0x007E,0x12,0x1ED7},
{0x007F,0x01,0x1F31},
{0x0080,0x13,0x1F36},
{0x0081,0x15,0x1F95},
};

static unsigned char ISO_88591_40_osdfont_dat[] = {
// 0x001A 21x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x82,0x00,0x04,0x10,0x00,0x20,
0x80,0x01,0x04,0x00,0x08,0x20,0x00,0x41,0x00,0x02,0x08,0x00,0x10,0x40,0x00,0x82,
0x00,0x04,0x10,0x00,0x20,0x80,0x01,0x04,0x00,0x08,0x20,0x00,0x41,0x00,0x02,0x08,
0x00,0x10,0x40,0x00,0x82,0x00,0x04,0x10,0x00,0x20,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x001B 21x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x82,0x00,0x04,0x10,0x00,0x20,
0x80,0x01,0x04,0x00,0x08,0x20,0x00,0x41,0x00,0x02,0x08,0x00,0x10,0x40,0x00,0x82,
0x00,0x04,0x10,0x00,0x20,0x80,0x01,0x04,0x00,0x08,0x20,0x00,0x41,0x00,0x02,0x08,
0x00,0x10,0x40,0x00,0x82,0x00,0x04,0x10,0x00,0x20,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x001C 1x40 -- 
0x00,0x00,0x00,0x00,0x00,
// 0x001D 1x40 -- 
0x00,0x00,0x00,0x00,0x00,
// 0x001E 1x40 -- 
0x00,0x00,0x00,0x00,0x00,
// 0x001F 1x40 -- 
0x00,0x00,0x00,0x00,0x00,
// 0x0020 1x40 -- 
0x00,0x00,0x00,0x00,0x00,
// 0x0021 8x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
0x0E,0x0E,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x0E,0x0E,0x0E,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0022 11x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x73,0x8E,0x71,0xCE,0x39,0xC7,0x38,
0xE7,0x1C,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0023 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x70,
0x0E,0x1C,0x07,0x0E,0x01,0xC3,0x80,0x70,0xE0,0x1C,0x38,0xFF,0xFF,0xBF,0xFF,0xEF,
0xFF,0xF8,0x38,0x70,0x0E,0x1C,0x07,0x8F,0x01,0xC3,0x80,0x70,0xE0,0xFF,0xFF,0xBF,
0xFF,0xEF,0xFF,0xF8,0xE1,0xC0,0x38,0x70,0x0E,0x1C,0x03,0x87,0x01,0xC3,0x80,0x70,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0024 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x3F,0x00,
0x3F,0xF0,0x1F,0xFE,0x0F,0x33,0x83,0x8C,0x70,0xE3,0x1C,0x38,0xC0,0x0E,0x30,0x01,
0xEC,0x00,0x7F,0x00,0x0F,0xF8,0x00,0x7F,0x80,0x0F,0xF0,0x03,0x3C,0x00,0xC7,0x80,
0x30,0xE7,0x0C,0x39,0xC3,0x0E,0x38,0xC7,0x8F,0x33,0xC1,0xFF,0xE0,0x3F,0xF0,0x03,
0xF8,0x00,0x30,0x00,0x0C,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0025 27x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0xE0,0x07,0x00,0xFF,0x01,0xC0,0x1C,0xE0,0x38,0x07,0x0E,
0x0E,0x00,0xE1,0xC1,0xC0,0x1C,0x38,0x70,0x03,0x87,0x0E,0x00,0x70,0xE3,0x80,0x0E,
0x1C,0x70,0x00,0xE7,0x1C,0x00,0x1F,0xC3,0x80,0x00,0xF0,0xE3,0xC0,0x00,0x1D,0xFE,
0x00,0x07,0x39,0xC0,0x01,0xEE,0x1C,0x00,0x39,0xC3,0x80,0x0E,0x38,0x70,0x01,0xC7,
0x0E,0x00,0x70,0xE1,0xC0,0x0E,0x1C,0x38,0x03,0x81,0xCE,0x00,0x70,0x3F,0x80,0x1C,
0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0026 20x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0xF0,0x00,0x3F,0xC0,0x07,0xFC,0x00,0xF1,0xE0,0x0E,0x0E,0x00,0xE0,0xE0,0x0E,0x0E,
0x00,0x71,0xC0,0x03,0xF8,0x00,0x3F,0x00,0x07,0xE0,0x00,0xFE,0x00,0x1E,0x70,0x03,
0x83,0x8E,0x70,0x1D,0xC7,0x01,0xDC,0x70,0x0F,0x87,0x00,0x70,0x78,0x07,0x83,0xC1,
0xFC,0x1F,0xFE,0xE0,0xFF,0xCE,0x07,0xF0,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x0027 5x40 -- 
0x00,0x00,0x00,0x01,0xCE,0x73,0x9C,0xE7,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0028 11x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x0C,0x03,0x00,0xE0,0x18,0x07,
0x00,0xC0,0x38,0x07,0x00,0xE0,0x38,0x07,0x00,0xE0,0x1C,0x03,0x80,0x70,0x0E,0x01,
0xC0,0x38,0x03,0x80,0x70,0x0E,0x00,0xE0,0x1C,0x01,0x80,0x38,0x03,0x00,0x30,0x03,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0029 10x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0xC0,0x18,0x07,0x00,0xC0,0x38,0x06,
0x01,0xC0,0x70,0x1C,0x03,0x80,0xE0,0x38,0x0E,0x03,0x80,0xE0,0x38,0x0E,0x03,0x81,
0xC0,0x70,0x1C,0x0E,0x03,0x80,0xC0,0x70,0x18,0x0C,0x06,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,
// 0x002A 12x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x60,0x06,0x07,0x6E,0x7F,
0xE1,0xF8,0x0F,0x01,0xF8,0x39,0xC1,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x002B 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x03,0x80,0x00,0xE0,0x00,0x38,0x00,
0x0E,0x00,0x03,0x80,0x3F,0xFF,0x8F,0xFF,0xE3,0xFF,0xF8,0x03,0x80,0x00,0xE0,0x00,
0x38,0x00,0x0E,0x00,0x03,0x80,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x002C 7x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xE1,0xC1,0x83,0x06,0x08,0x30,0x00,0x00,
0x00,0x00,0x00,
// 0x002D 11x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xE7,0xFC,0xFF,0x80,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x002E 7x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xE1,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,
// 0x002F 10x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x06,0x03,0x00,0xC0,0x30,0x18,0x06,
0x01,0x80,0xC0,0x30,0x0C,0x07,0x01,0x80,0x60,0x18,0x0C,0x03,0x00,0xC0,0x60,0x18,
0x06,0x03,0x80,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,
// 0x0030 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,
0x3F,0xF0,0x1F,0xFE,0x0F,0x87,0x83,0x80,0x70,0xE0,0x1C,0x70,0x03,0x9C,0x00,0xE7,
0x00,0x39,0xC0,0x0E,0x70,0x03,0x9C,0x00,0xE7,0x00,0x39,0xC0,0x0E,0x70,0x03,0x9C,
0x00,0xE7,0x00,0x38,0xE0,0x1C,0x38,0x07,0x0F,0x87,0xC1,0xFF,0xE0,0x3F,0xF0,0x03,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0031 13x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x0E,0x00,0xF0,0x0F,
0x81,0xFC,0x1E,0xE1,0xE7,0x0C,0x38,0x01,0xC0,0x0E,0x00,0x70,0x03,0x80,0x1C,0x00,
0xE0,0x07,0x00,0x38,0x01,0xC0,0x0E,0x00,0x70,0x03,0x80,0x1C,0x00,0xE0,0x07,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,
// 0x0032 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xC0,0x3F,
0xF8,0x3F,0xFE,0x1E,0x0F,0x1C,0x03,0xCE,0x00,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,
0x00,0x1C,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x1E,0x00,0x1E,
0x00,0x1C,0x00,0x1C,0x00,0x1C,0x00,0x0F,0xFF,0xCF,0xFF,0xE7,0xFF,0xF0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x0033 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,
0x3F,0xF0,0x1F,0xFE,0x0F,0x07,0x87,0x80,0x71,0xC0,0x1C,0x00,0x07,0x00,0x03,0xC0,
0x01,0xE0,0x07,0xF0,0x01,0xFC,0x00,0x7F,0x80,0x00,0xF0,0x00,0x1E,0x00,0x03,0x80,
0x00,0xE0,0x00,0x39,0xC0,0x0E,0x78,0x07,0x0F,0x03,0xC1,0xFF,0xE0,0x3F,0xF0,0x03,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0034 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,
0x00,0x70,0x00,0x3C,0x00,0x1F,0x00,0x07,0xC0,0x03,0xF0,0x01,0xDC,0x00,0xF7,0x00,
0x39,0xC0,0x1C,0x70,0x0E,0x1C,0x03,0x87,0x01,0xC1,0xC0,0xE0,0x70,0x70,0x1C,0x1F,
0xFF,0xE7,0xFF,0xF9,0xFF,0xFE,0x00,0x1C,0x00,0x07,0x00,0x01,0xC0,0x00,0x70,0x00,
0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0035 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,
0x7F,0xFC,0x1F,0xFF,0x0E,0x00,0x03,0x80,0x00,0xE0,0x00,0x38,0x00,0x0E,0x7C,0x03,
0x7F,0xC1,0xFF,0xF8,0x7C,0x0F,0x1C,0x01,0xC0,0x00,0x38,0x00,0x0E,0x00,0x03,0x80,
0x00,0xE0,0x00,0x39,0xC0,0x0E,0x78,0x07,0x0F,0x03,0xC3,0xFF,0xE0,0x3F,0xF0,0x07,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0036 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x80,
0x1F,0xF8,0x0F,0xFF,0x07,0x83,0xC3,0xC0,0x78,0xE0,0x0E,0x38,0x00,0x1C,0x00,0x07,
0x1F,0x81,0xDF,0xF0,0x7F,0xFE,0x1F,0x83,0xC7,0x80,0x79,0xC0,0x0E,0x70,0x03,0x9C,
0x00,0xE7,0x00,0x38,0xE0,0x0E,0x38,0x07,0x07,0x83,0xC1,0xFF,0xE0,0x1F,0xF0,0x03,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0037 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xF8,
0xFF,0xFE,0x3F,0xFF,0x80,0x00,0xC0,0x00,0x60,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,
0x03,0x80,0x01,0xC0,0x00,0x70,0x00,0x38,0x00,0x0E,0x00,0x07,0x00,0x01,0xC0,0x00,
0xE0,0x00,0x38,0x00,0x0E,0x00,0x03,0x80,0x01,0xC0,0x00,0x70,0x00,0x1C,0x00,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0038 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,
0x3F,0xF0,0x1F,0xFE,0x0F,0x03,0x83,0x80,0x70,0xE0,0x1C,0x38,0x07,0x0E,0x01,0xC1,
0xC0,0xE0,0x3F,0xF0,0x07,0xF8,0x07,0xFF,0x83,0xC0,0xF0,0xE0,0x1C,0x70,0x03,0x9C,
0x00,0xE7,0x00,0x39,0xC0,0x0E,0x78,0x07,0x8F,0x03,0xC1,0xFF,0xE0,0x3F,0xF0,0x03,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0039 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,
0x3F,0xE0,0x1F,0xFE,0x0F,0x03,0x83,0x80,0x71,0xC0,0x0C,0x70,0x03,0x9C,0x00,0xE7,
0x00,0x39,0xC0,0x0E,0x78,0x07,0x8F,0x03,0xE1,0xFF,0xF8,0x3F,0xEE,0x07,0xE3,0x80,
0x00,0xE0,0x00,0x71,0xC0,0x1C,0x78,0x0F,0x0F,0x07,0x83,0xFF,0xC0,0x7F,0xE0,0x07,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x003A 7x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC3,0x87,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xE1,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,
// 0x003B 7x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC3,0x87,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xE1,0xC1,0x83,0x06,0x08,0x30,0x00,0x00,
0x00,0x00,0x00,
// 0x003C 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x1E,0x00,0x1F,0x80,0x3F,0xC0,
0x3F,0x80,0x7F,0x00,0x3F,0x00,0x0E,0x00,0x03,0xF0,0x00,0x7F,0x00,0x03,0xF8,0x00,
0x3F,0xC0,0x01,0xF8,0x00,0x1E,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x003D 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0x8F,0xFF,0xE3,
0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFE,0x3F,0xFF,0x8F,
0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x003E 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0xF0,0x00,0x3F,0x00,0x07,0xF8,0x00,
0x3F,0x80,0x01,0xFC,0x00,0x1F,0x80,0x00,0xE0,0x01,0xF8,0x01,0xFC,0x03,0xF8,0x07,
0xF8,0x03,0xF0,0x00,0xF0,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x003F 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x00,
0x3F,0xF0,0x1F,0xFF,0x0F,0x83,0xC3,0x80,0x79,0xC0,0x0E,0x70,0x03,0x80,0x00,0xE0,
0x00,0x78,0x00,0x3C,0x00,0x1E,0x00,0x0F,0x00,0x07,0x80,0x01,0xC0,0x00,0xF0,0x00,
0x38,0x00,0x0E,0x00,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x03,0x80,0x00,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0040 33x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF0,0x00,0x00,0x7F,0xFE,
0x00,0x00,0x7F,0xFF,0xC0,0x00,0xFE,0x03,0xF0,0x00,0xF8,0x00,0x7C,0x00,0xF8,0x00,
0x0F,0x00,0x78,0x7C,0x73,0xC0,0x78,0x7F,0x38,0xE0,0x38,0x7F,0xF8,0x70,0x38,0x78,
0xFC,0x1C,0x1C,0x78,0x3E,0x0E,0x0E,0x38,0x0F,0x07,0x0E,0x1C,0x07,0x03,0x87,0x1C,
0x03,0x81,0xC3,0x8E,0x01,0xC0,0xE1,0xC7,0x00,0xE0,0xE0,0xE3,0x80,0xF0,0x70,0x71,
0xC0,0x70,0x78,0x38,0xF0,0x78,0x78,0x1E,0x38,0x7C,0x78,0x07,0x1F,0xFF,0xF8,0x03,
0x87,0xF7,0xF8,0x01,0xE1,0xE1,0xF0,0x00,0x78,0x00,0x00,0x38,0x1E,0x00,0x00,0x78,
0x0F,0xC0,0x00,0x78,0x01,0xFC,0x01,0xF8,0x00,0x7F,0xFF,0xF8,0x00,0x0F,0xFF,0xF0,
0x00,0x00,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x0041 22x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x0F,0x80,0x00,0x3E,0x00,0x00,0xF8,0x00,0x07,0x70,0x00,0x1D,0xC0,0x00,0x77,
0x00,0x03,0x8E,0x00,0x0E,0x38,0x00,0x70,0x70,0x01,0xC1,0xC0,0x07,0x07,0x00,0x38,
0x0E,0x00,0xE0,0x38,0x03,0xFF,0xE0,0x1F,0xFF,0xC0,0x7F,0xFF,0x03,0x80,0x0E,0x0E,
0x00,0x38,0x38,0x00,0xE1,0xC0,0x01,0xC7,0x00,0x07,0x1C,0x00,0x1C,0xE0,0x00,0x38,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0042 21x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xF8,0x03,0xFF,0xF0,0x1F,0xFF,0xC0,0xE0,0x1F,0x07,0x00,0x38,0x38,0x01,0xC1,
0xC0,0x0E,0x0E,0x00,0x70,0x70,0x0F,0x03,0xFF,0xF0,0x1F,0xFF,0x80,0xFF,0xFE,0x07,
0x00,0x78,0x38,0x01,0xE1,0xC0,0x07,0x0E,0x00,0x38,0x70,0x01,0xC3,0x80,0x0E,0x1C,
0x00,0xF0,0xE0,0x0F,0x07,0xFF,0xF8,0x3F,0xFF,0x81,0xFF,0xF0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0043 23x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x3F,0x80,0x01,0xFF,0xC0,0x07,0xFF,0xE0,0x1F,0x03,0xC0,0x78,0x03,0xC1,
0xE0,0x03,0xC3,0x80,0x03,0x8F,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x70,0x00,
0x00,0xE0,0x00,0x01,0xC0,0x00,0x03,0x80,0x00,0x07,0x00,0x00,0x07,0x00,0x03,0x8E,
0x00,0x0F,0x1E,0x00,0x1C,0x1E,0x00,0x78,0x1F,0x03,0xE0,0x1F,0xFF,0x80,0x1F,0xFE,
0x00,0x0F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,
// 0x0044 23x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xC0,0x0F,0xFF,0xE0,0x1F,0xFF,0xE0,0x38,0x03,0xE0,0x70,0x01,0xC0,
0xE0,0x03,0xC1,0xC0,0x03,0x83,0x80,0x07,0x87,0x00,0x07,0x0E,0x00,0x0E,0x1C,0x00,
0x1C,0x38,0x00,0x38,0x70,0x00,0x70,0xE0,0x00,0xE1,0xC0,0x01,0xC3,0x80,0x07,0x87,
0x00,0x0E,0x0E,0x00,0x3C,0x1C,0x00,0x70,0x38,0x03,0xE0,0x7F,0xFF,0x80,0xFF,0xFE,
0x01,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,
// 0x0045 20x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xC1,0xFF,0xFC,0x1F,0xFF,0xC1,0xC0,0x00,0x1C,0x00,0x01,0xC0,0x00,0x1C,0x00,
0x01,0xC0,0x00,0x1C,0x00,0x01,0xFF,0xF8,0x1F,0xFF,0x81,0xFF,0xF8,0x1C,0x00,0x01,
0xC0,0x00,0x1C,0x00,0x01,0xC0,0x00,0x1C,0x00,0x01,0xC0,0x00,0x1C,0x00,0x01,0xC0,
0x00,0x1F,0xFF,0xE1,0xFF,0xFE,0x1F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x0046 20x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
0xFF,0xE1,0xFF,0xFE,0x1F,0xFF,0xE1,0xC0,0x00,0x1C,0x00,0x01,0xC0,0x00,0x1C,0x00,
0x01,0xC0,0x00,0x1C,0x00,0x01,0xC0,0x00,0x1F,0xFF,0x81,0xFF,0xF8,0x1F,0xFF,0x81,
0xC0,0x00,0x1C,0x00,0x01,0xC0,0x00,0x1C,0x00,0x01,0xC0,0x00,0x1C,0x00,0x01,0xC0,
0x00,0x1C,0x00,0x01,0xC0,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x0047 24x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x7F,0x80,0x03,0xFF,0xE0,0x07,0xFF,0xF0,0x0F,0x80,0xF8,0x1E,0x00,
0x3C,0x3C,0x00,0x1C,0x38,0x00,0x0E,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,
0x70,0x00,0x00,0x70,0x07,0xFE,0x70,0x07,0xFE,0x70,0x07,0xFE,0x70,0x00,0x0E,0x38,
0x00,0x0E,0x38,0x00,0x0E,0x3C,0x00,0x0E,0x1E,0x00,0x1E,0x0F,0xC0,0xFE,0x07,0xFF,
0xF8,0x01,0xFF,0xF0,0x00,0x7F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0048 21x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x70,0x01,0xC3,0x80,0x0E,0x1C,0x00,0x70,0xE0,0x03,0x87,0x00,0x1C,0x38,0x00,0xE1,
0xC0,0x07,0x0E,0x00,0x38,0x70,0x01,0xC3,0xFF,0xFE,0x1F,0xFF,0xF0,0xFF,0xFF,0x87,
0x00,0x1C,0x38,0x00,0xE1,0xC0,0x07,0x0E,0x00,0x38,0x70,0x01,0xC3,0x80,0x0E,0x1C,
0x00,0x70,0xE0,0x03,0x87,0x00,0x1C,0x38,0x00,0xE1,0xC0,0x07,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0049 7x40 -- 
0x00,0x00,0x00,0x00,0x00,0x07,0x0E,0x1C,0x38,0x70,0xE1,0xC3,0x87,0x0E,0x1C,0x38,
0x70,0xE1,0xC3,0x87,0x0E,0x1C,0x38,0x70,0xE1,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,
// 0x004A 14x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x0E,0x00,0x38,
0x00,0xE0,0x03,0x80,0x0E,0x00,0x38,0x00,0xE0,0x03,0x80,0x0E,0x00,0x38,0x00,0xE0,
0x03,0x80,0x0E,0x00,0x38,0x00,0xE7,0x03,0x9C,0x0E,0x70,0x39,0xE1,0xC3,0xFF,0x07,
0xF8,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,
// 0x004B 23x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x07,0x00,0x1E,0x0E,0x00,0x78,0x1C,0x01,0xE0,0x38,0x07,0x80,0x70,0x1E,0x00,
0xE0,0x78,0x01,0xC1,0xE0,0x03,0x87,0x80,0x07,0x1E,0x00,0x0E,0x78,0x00,0x1D,0xF0,
0x00,0x3F,0xF0,0x00,0x7E,0xF0,0x00,0xF8,0xF0,0x01,0xE1,0xE0,0x03,0x81,0xE0,0x07,
0x01,0xE0,0x0E,0x01,0xE0,0x1C,0x01,0xC0,0x38,0x01,0xC0,0x70,0x03,0xC0,0xE0,0x03,
0xC1,0xC0,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,
// 0x004C 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x00,
0x70,0x00,0x1C,0x00,0x07,0x00,0x01,0xC0,0x00,0x70,0x00,0x1C,0x00,0x07,0x00,0x01,
0xC0,0x00,0x70,0x00,0x1C,0x00,0x07,0x00,0x01,0xC0,0x00,0x70,0x00,0x1C,0x00,0x07,
0x00,0x01,0xC0,0x00,0x70,0x00,0x1C,0x00,0x07,0x00,0x01,0xFF,0xF8,0x7F,0xFE,0x1F,
0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x004D 25x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x7C,0x00,0x7C,0x3E,0x00,0x3E,0x1F,0x80,0x3F,0x0F,0xC0,0x1F,0x87,
0xE0,0x0F,0xC3,0xB8,0x0E,0xE1,0xDC,0x07,0x70,0xEE,0x03,0xB8,0x73,0x01,0x9C,0x39,
0xC1,0xCE,0x1C,0xE0,0xE7,0x0E,0x70,0x73,0x87,0x1C,0x71,0xC3,0x8E,0x38,0xE1,0xC7,
0x1C,0x70,0xE1,0x8C,0x38,0x70,0xEE,0x1C,0x38,0x77,0x0E,0x1C,0x3B,0x87,0x0E,0x0D,
0x83,0x87,0x07,0xC1,0xC3,0x83,0xE0,0xE1,0xC0,0xE0,0x70,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x004E 21x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x70,0x01,0xC3,0xC0,0x0E,0x1F,0x00,0x70,0xF8,0x03,0x87,0xE0,0x1C,0x3F,0x00,0xE1,
0xDC,0x07,0x0E,0x70,0x38,0x73,0x81,0xC3,0x8E,0x0E,0x1C,0x70,0x70,0xE1,0xC3,0x87,
0x07,0x1C,0x38,0x38,0xE1,0xC0,0xE7,0x0E,0x07,0x38,0x70,0x1D,0xC3,0x80,0x7E,0x1C,
0x03,0xF0,0xE0,0x0F,0x87,0x00,0x7C,0x38,0x01,0xE1,0xC0,0x07,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x004F 25x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0xFC,0x00,0x07,0xFF,0xC0,0x07,0xFF,0xF0,0x07,0xC0,0x7C,0x07,
0x80,0x0F,0x07,0x80,0x03,0xC3,0x80,0x00,0xE1,0xC0,0x00,0x71,0xC0,0x00,0x1C,0xE0,
0x00,0x0E,0x70,0x00,0x07,0x38,0x00,0x03,0x9C,0x00,0x01,0xCE,0x00,0x00,0xE7,0x00,
0x00,0x71,0xC0,0x00,0x70,0xE0,0x00,0x38,0x78,0x00,0x3C,0x1E,0x00,0x3C,0x07,0xC0,
0x7C,0x01,0xFF,0xFC,0x00,0x7F,0xFC,0x00,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0050 21x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x7F,0xFC,0x03,0xFF,0xF8,0x1F,0xFF,0xE0,0xE0,0x0F,0x07,0x00,0x3C,0x38,0x00,0xE1,
0xC0,0x07,0x0E,0x00,0x38,0x70,0x01,0xC3,0x80,0x1E,0x1C,0x01,0xE0,0xFF,0xFF,0x07,
0xFF,0xF0,0x3F,0xFE,0x01,0xC0,0x00,0x0E,0x00,0x00,0x70,0x00,0x03,0x80,0x00,0x1C,
0x00,0x00,0xE0,0x00,0x07,0x00,0x00,0x38,0x00,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0051 25x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x03,0xFC,0x00,0x07,0xFF,0x80,0x07,0xFF,0xE0,0x07,0xC0,0xF8,0x07,
0x80,0x1E,0x07,0x80,0x07,0x83,0x80,0x01,0xC1,0xC0,0x00,0xE1,0xC0,0x00,0x38,0xE0,
0x00,0x1C,0x70,0x00,0x0E,0x38,0x00,0x07,0x1C,0x00,0x03,0x8E,0x00,0x01,0xC7,0x00,
0x00,0xE1,0xC0,0x00,0xE0,0xE0,0x10,0x70,0x78,0x1E,0x70,0x1E,0x07,0xF8,0x07,0xC0,
0xF8,0x01,0xFF,0xFE,0x00,0x7F,0xFF,0x80,0x07,0xF1,0xF0,0x00,0x00,0x70,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0052 22x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0xFF,0xF0,0x07,0xFF,0xF0,0x1F,0xFF,0xE0,0x70,0x07,0x81,0xC0,0x0F,0x07,0x00,
0x1C,0x1C,0x00,0x70,0x70,0x01,0xC1,0xC0,0x0F,0x07,0x00,0x78,0x1F,0xFF,0xE0,0x7F,
0xFF,0x01,0xFF,0xF0,0x07,0x07,0x80,0x1C,0x0F,0x00,0x70,0x1E,0x01,0xC0,0x38,0x07,
0x00,0xF0,0x1C,0x01,0xE0,0x70,0x03,0x81,0xC0,0x0F,0x07,0x00,0x1C,0x1C,0x00,0x78,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0053 20x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
0xF8,0x00,0xFF,0xE0,0x1F,0xFF,0x01,0xE0,0x78,0x3C,0x03,0xC3,0x80,0x1C,0x38,0x01,
0xC3,0x80,0x00,0x1C,0x00,0x01,0xFC,0x00,0x0F,0xFC,0x00,0x3F,0xF0,0x00,0x3F,0x80,
0x00,0x7C,0x00,0x01,0xE7,0x00,0x0E,0x70,0x00,0xE7,0x80,0x0E,0x38,0x01,0xE3,0xE0,
0x3C,0x1F,0xFF,0x80,0xFF,0xF0,0x01,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x0054 20x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xEF,0xFF,0xFE,0xFF,0xFF,0xE0,0x0E,0x00,0x00,0xE0,0x00,0x0E,0x00,0x00,0xE0,
0x00,0x0E,0x00,0x00,0xE0,0x00,0x0E,0x00,0x00,0xE0,0x00,0x0E,0x00,0x00,0xE0,0x00,
0x0E,0x00,0x00,0xE0,0x00,0x0E,0x00,0x00,0xE0,0x00,0x0E,0x00,0x00,0xE0,0x00,0x0E,
0x00,0x00,0xE0,0x00,0x0E,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x0055 21x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x70,0x01,0xC3,0x80,0x0E,0x1C,0x00,0x70,0xE0,0x03,0x87,0x00,0x1C,0x38,0x00,0xE1,
0xC0,0x07,0x0E,0x00,0x38,0x70,0x01,0xC3,0x80,0x0E,0x1C,0x00,0x70,0xE0,0x03,0x87,
0x00,0x1C,0x38,0x00,0xE1,0xC0,0x07,0x0E,0x00,0x38,0x70,0x01,0xC3,0xC0,0x1E,0x0E,
0x00,0xE0,0x7C,0x1F,0x01,0xFF,0xF0,0x07,0xFF,0x00,0x0F,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0056 22x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0E,0x00,0x03,0xBC,0x00,0x1E,0x70,0x00,0x71,0xC0,0x01,0xC3,0x80,0x0E,0x0E,0x00,
0x38,0x38,0x00,0xE0,0x70,0x07,0x01,0xC0,0x1C,0x07,0x80,0xF0,0x0E,0x03,0x80,0x38,
0x0E,0x00,0x70,0x70,0x01,0xC1,0xC0,0x07,0x07,0x00,0x0E,0x38,0x00,0x38,0xE0,0x00,
0xF7,0x80,0x01,0xDC,0x00,0x07,0x70,0x00,0x1F,0xC0,0x00,0x3E,0x00,0x00,0xF8,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0057 32x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xC0,0x0E,0xE0,0x07,0xC0,0x0E,
0x70,0x07,0xC0,0x1C,0x70,0x0E,0xE0,0x1C,0x70,0x0E,0xE0,0x1C,0x70,0x0E,0xE0,0x1C,
0x70,0x1C,0x70,0x1C,0x38,0x1C,0x70,0x38,0x38,0x1C,0x70,0x38,0x38,0x1C,0x70,0x38,
0x38,0x38,0x38,0x38,0x1C,0x38,0x38,0x70,0x1C,0x38,0x38,0x70,0x1C,0x70,0x1C,0x70,
0x1C,0x70,0x1C,0x70,0x0E,0x70,0x1C,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,
0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x0E,0xE0,0x07,0xC0,0x07,0xC0,0x07,0xC0,0x07,0xC0,
0x07,0xC0,0x07,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0058 22x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x07,0x80,0x0F,0x0F,0x00,0x78,0x1C,0x01,0xC0,0x38,0x0E,0x00,0xF0,0x78,0x01,0xE3,
0xC0,0x03,0x8E,0x00,0x07,0x70,0x00,0x1D,0xC0,0x00,0x3E,0x00,0x00,0x70,0x00,0x01,
0xE0,0x00,0x0F,0x80,0x00,0x77,0x00,0x03,0xDE,0x00,0x0E,0x38,0x00,0x70,0x70,0x03,
0xC1,0xE0,0x1E,0x03,0xC0,0x70,0x07,0x03,0x80,0x0E,0x1E,0x00,0x3C,0xF0,0x00,0x78,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0059 22x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0E,0x00,0x07,0x9C,0x00,0x3C,0x38,0x00,0xE0,0xF0,0x07,0x81,0xC0,0x3C,0x03,0x80,
0xE0,0x0F,0x07,0x80,0x1E,0x3C,0x00,0x38,0xE0,0x00,0xF7,0x80,0x01,0xDC,0x00,0x03,
0xE0,0x00,0x0F,0x80,0x00,0x1C,0x00,0x00,0x70,0x00,0x01,0xC0,0x00,0x07,0x00,0x00,
0x1C,0x00,0x00,0x70,0x00,0x01,0xC0,0x00,0x07,0x00,0x00,0x1C,0x00,0x00,0x70,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x005A 20x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,
0xFF,0xC7,0xFF,0xFC,0x7F,0xFF,0xC0,0x00,0x3C,0x00,0x07,0x80,0x00,0xF0,0x00,0x1E,
0x00,0x01,0xC0,0x00,0x38,0x00,0x07,0x00,0x00,0xF0,0x00,0x1E,0x00,0x03,0xC0,0x00,
0x78,0x00,0x07,0x00,0x00,0xE0,0x00,0x1C,0x00,0x03,0xC0,0x00,0x78,0x00,0x0F,0x00,
0x00,0xFF,0xFF,0xEF,0xFF,0xFE,0xFF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
// 0x005B 9x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x7E,0x3F,0x1C,0x0E,0x07,0x03,0x81,0xC0,
0xE0,0x70,0x38,0x1C,0x0E,0x07,0x03,0x81,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x07,0x03,
0x81,0xC0,0xE0,0x70,0x3F,0x1F,0x8F,0xC0,0x00,0x00,0x00,0x00,0x00,
// 0x005C 11x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x03,0x00,0x30,0x06,0x00,0xC0,0x0C,
0x01,0x80,0x30,0x03,0x00,0x60,0x0C,0x01,0xC0,0x18,0x03,0x00,0x60,0x06,0x00,0xC0,
0x18,0x01,0x80,0x30,0x06,0x00,0xE0,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x005D 8x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
0x7E,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,
// 0x005E 14x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x01,0xE0,0x07,0x80,
0x1E,0x00,0xFC,0x03,0x30,0x1C,0xE0,0x73,0x83,0x87,0x0E,0x1C,0x38,0x71,0xC0,0xE0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,
// 0x005F 19x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xDF,0xFF,
0xFB,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0060 8x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x3C,0x1C,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0061 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0xFF,0xE0,0xFF,0xF0,
0xF0,0x3C,0x70,0x0E,0x00,0x07,0x00,0x0F,0x80,0xFF,0xC1,0xFF,0xE1,0xFE,0x71,0xE0,
0x38,0xE0,0x1C,0x70,0x1E,0x3C,0x3F,0x0F,0xFF,0x87,0xFD,0xC0,0xFC,0x70,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x0062 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x70,
0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x03,0x9F,0x01,0xDF,0xC0,0xFF,0xF0,
0x7C,0x3C,0x3C,0x0E,0x1E,0x03,0x8E,0x01,0xC7,0x00,0xE3,0x80,0x71,0xC0,0x38,0xE0,
0x1C,0x70,0x1E,0x3C,0x0E,0x1F,0x0F,0x0F,0xFF,0x07,0x7F,0x03,0x9F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x0063 16x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x0F,0xF0,0x1F,0xF8,0x3C,0x3C,
0x38,0x1C,0x70,0x0E,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x00,0x70,0x0E,
0x38,0x1E,0x3C,0x3C,0x1F,0xFC,0x0F,0xF8,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0064 16x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,
0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x0E,0x07,0xCE,0x0F,0xEE,0x1F,0xFE,0x3C,0x3E,
0x38,0x1E,0x70,0x1E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x78,0x0E,
0x38,0x1E,0x3C,0x3E,0x1F,0xFE,0x0F,0xEE,0x07,0xCE,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0065 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x7F,0xC0,0x7F,0xF0,
0x78,0x3C,0x38,0x0E,0x38,0x03,0x9C,0x01,0xCF,0xFF,0xE7,0xFF,0xF3,0x80,0x01,0xC0,
0x00,0xF0,0x00,0x38,0x07,0x1F,0x0F,0x07,0xFF,0x81,0xFF,0x80,0x3F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x0066 11x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xF0,0x7E,0x1F,0xC3,0x80,0x70,0x0E,
0x07,0xF8,0xFF,0x1F,0xE0,0xE0,0x1C,0x03,0x80,0x70,0x0E,0x01,0xC0,0x38,0x07,0x00,
0xE0,0x1C,0x03,0x80,0x70,0x0E,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0067 16x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xCE,0x0F,0xFE,0x1F,0xFE,0x3C,0x3E,
0x38,0x1E,0x70,0x1E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,
0x38,0x1E,0x3C,0x3E,0x1F,0xFE,0x0F,0xFE,0x07,0xCE,0x00,0x0E,0x70,0x1E,0x78,0x3C,
0x3F,0xFC,0x3F,0xF8,0x0F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0068 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x70,
0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x03,0x8F,0x81,0xDF,0xF0,0xFF,0xF8,
0x7C,0x1E,0x3C,0x07,0x1C,0x03,0x8E,0x01,0xC7,0x00,0xE3,0x80,0x71,0xC0,0x38,0xE0,
0x1C,0x70,0x0E,0x38,0x07,0x1C,0x03,0x8E,0x01,0xC7,0x00,0xE3,0x80,0x70,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x0069 6x40 -- 
0x00,0x00,0x00,0x00,0x03,0x8E,0x38,0x00,0x00,0x38,0xE3,0x8E,0x38,0xE3,0x8E,0x38,
0xE3,0x8E,0x38,0xE3,0x8E,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x006A 6x40 -- 
0x00,0x00,0x00,0x00,0x03,0x8E,0x38,0x00,0x00,0x38,0xE3,0x8E,0x38,0xE3,0x8E,0x38,
0xE3,0x8E,0x38,0xE3,0x8E,0x38,0xE3,0x8E,0xFB,0xCE,0x00,0x00,0x00,0x00,
// 0x006B 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x70,
0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x03,0x80,0xF1,0xC0,0xF0,0xE0,0xF0,
0x70,0xF0,0x38,0xF0,0x1C,0xF0,0x0E,0xF0,0x07,0xF8,0x03,0xFE,0x01,0xE7,0x00,0xE3,
0xC0,0x70,0xF0,0x38,0x38,0x1C,0x1E,0x0E,0x07,0x07,0x01,0xC3,0x80,0xF0,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x006C 6x40 -- 
0x00,0x00,0x00,0x00,0x03,0x8E,0x38,0xE3,0x8E,0x38,0xE3,0x8E,0x38,0xE3,0x8E,0x38,
0xE3,0x8E,0x38,0xE3,0x8E,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x006D 26x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0xF0,0x7C,0x0E,0xFF,0x3F,0xC3,0xFF,0xDF,
0xF0,0xF8,0x7E,0x1E,0x3C,0x0F,0x03,0x8E,0x03,0x80,0xE3,0x80,0xE0,0x38,0xE0,0x38,
0x0E,0x38,0x0E,0x03,0x8E,0x03,0x80,0xE3,0x80,0xE0,0x38,0xE0,0x38,0x0E,0x38,0x0E,
0x03,0x8E,0x03,0x80,0xE3,0x80,0xE0,0x38,0xE0,0x38,0x0E,0x38,0x0E,0x03,0x80,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,
// 0x006E 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x9F,0x81,0xDF,0xF0,0xFF,0xF8,
0x7C,0x1E,0x3C,0x07,0x1C,0x03,0x8E,0x01,0xC7,0x00,0xE3,0x80,0x71,0xC0,0x38,0xE0,
0x1C,0x70,0x0E,0x38,0x07,0x1C,0x03,0x8E,0x01,0xC7,0x00,0xE3,0x80,0x70,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x006F 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x7F,0xC0,0x7F,0xF0,
0x78,0x3C,0x38,0x0E,0x3C,0x07,0x9C,0x01,0xCE,0x00,0xE7,0x00,0x73,0x80,0x39,0xC0,
0x1C,0xF0,0x1E,0x38,0x0E,0x1E,0x0F,0x07,0xFF,0x01,0xFF,0x00,0x3E,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x0070 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x9F,0x01,0xDF,0xC0,0xFF,0xF0,
0x7C,0x3C,0x3C,0x0E,0x1E,0x03,0x8E,0x01,0xC7,0x00,0xE3,0x80,0x71,0xC0,0x38,0xE0,
0x1C,0x70,0x0E,0x3C,0x0E,0x1F,0x0F,0x0F,0xFF,0x07,0x7F,0x03,0x9F,0x01,0xC0,0x00,
0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x0071 16x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xCE,0x1F,0xEE,0x1F,0xFE,0x3C,0x3E,
0x38,0x1E,0x70,0x1E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x70,0x0E,0x78,0x0E,
0x38,0x1E,0x3C,0x3E,0x1F,0xFE,0x0F,0xEE,0x07,0xCE,0x00,0x0E,0x00,0x0E,0x00,0x0E,
0x00,0x0E,0x00,0x0E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0072 12x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x39,0xE3,0xBE,0x3F,0xC3,0xE0,0x3C,0x03,0x80,0x38,0x03,0x80,0x38,0x03,
0x80,0x38,0x03,0x80,0x38,0x03,0x80,0x38,0x03,0x80,0x38,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0073 16x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xE0,0x1F,0xF0,0x3F,0xF8,0x78,0x3C,
0x70,0x1C,0x78,0x00,0x7F,0x00,0x3F,0xE0,0x1F,0xF8,0x03,0xFC,0x00,0x3E,0x70,0x0E,
0x78,0x0E,0x3C,0x1E,0x3F,0xFC,0x1F,0xF8,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0074 9x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x30,0x38,0x1C,0x0E,0x07,0x0F,0xF7,0xFB,
0xFC,0x70,0x38,0x1C,0x0E,0x07,0x03,0x81,0xC0,0xE0,0x70,0x38,0x1C,0x0F,0xC7,0xE1,
0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0075 17x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x71,0xC0,0x38,0xE0,0x1C,
0x70,0x0E,0x38,0x07,0x1C,0x03,0x8E,0x01,0xC7,0x00,0xE3,0x80,0x71,0xC0,0x38,0xE0,
0x1C,0x70,0x0E,0x38,0x0F,0x1E,0x0F,0x87,0xFD,0xC3,0xFE,0xE0,0x7C,0x70,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
// 0x0076 16x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0E,0x70,0x1C,0x70,0x1C,0x70,0x1C,
0x38,0x38,0x38,0x38,0x38,0x38,0x1C,0x70,0x1C,0x70,0x1C,0x70,0x0E,0xE0,0x0E,0xE0,
0x06,0xC0,0x06,0xC0,0x07,0xC0,0x03,0x80,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0077 24x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xE0,0x38,0x0E,0xE0,0x38,0x0E,0xE0,0x7C,0x0E,0x70,0x7C,0x1C,
0x70,0x6C,0x1C,0x70,0x6C,0x1C,0x38,0xEE,0x38,0x38,0xC6,0x38,0x38,0xC6,0x38,0x18,
0xC6,0x70,0x1D,0xC7,0x70,0x1D,0x83,0x70,0x0D,0x83,0x60,0x0F,0x83,0xE0,0x0F,0x83,
0xE0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0078 15x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x01,0xCE,0x07,0x0E,0x1C,0x1C,0x38,0x1C,0xE0,
0x1F,0x80,0x3F,0x00,0x3C,0x00,0x78,0x00,0xF0,0x03,0xF0,0x07,0xE0,0x1C,0xE0,0x70,
0xE0,0xE1,0xC3,0x81,0xCE,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0079 16x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x0E,0x70,0x1E,0x70,0x1C,0x70,0x1C,
0x38,0x38,0x38,0x38,0x38,0x38,0x1C,0x70,0x1C,0x70,0x0E,0x70,0x0E,0xE0,0x0E,0xE0,
0x06,0xE0,0x07,0xC0,0x07,0xC0,0x03,0xC0,0x03,0x80,0x03,0x80,0x07,0x00,0x07,0x00,
0x3F,0x00,0x3E,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x007A 15x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xCF,0xFF,0x9F,0xFF,0x00,0x1E,0x00,0x78,
0x01,0xE0,0x07,0x80,0x1E,0x00,0x78,0x01,0xE0,0x07,0x80,0x1E,0x00,0x78,0x01,0xE0,
0x03,0xFF,0xF7,0xFF,0xEF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x007B 11x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x3E,0x0F,0xC1,0xE0,0x38,0x07,
0x00,0xE0,0x1C,0x03,0x80,0x70,0x0E,0x01,0xC0,0x70,0x3C,0x06,0x00,0xF0,0x07,0x00,
0x70,0x0E,0x01,0xC0,0x38,0x07,0x00,0xE0,0x1C,0x03,0x80,0x70,0x0F,0xC0,0xF8,0x0F,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x007C 6x40 -- 
0x00,0x00,0x00,0x00,0x01,0x86,0x18,0x61,0x86,0x18,0x61,0x86,0x18,0x61,0x86,0x18,
0x61,0x86,0x18,0x61,0x86,0x18,0x61,0x86,0x18,0x61,0x86,0x00,0x00,0x00,
// 0x007D 11x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x03,0xE0,0x7E,0x01,0xC0,0x38,0x07,
0x00,0xE0,0x1C,0x03,0x80,0x70,0x0E,0x01,0xC0,0x1C,0x01,0xE0,0x0C,0x07,0x81,0xC0,
0x70,0x0E,0x01,0xC0,0x38,0x07,0x00,0xE0,0x1C,0x03,0x80,0xF0,0x7E,0x0F,0x81,0xE0,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x007E 18x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x7C,0x00,0x3F,0xC0,0x9F,0xF8,0x66,0x1F,0xF9,0x01,0xFC,0x00,0x3E,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x007F 1x40 -- 
0x00,0x00,0x00,0x00,0x00,
// 0x0080 19x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
0xC0,0x0F,0xFE,0x07,0xFF,0x81,0xF0,0x10,0x3C,0x00,0x0F,0x00,0x01,0xC0,0x00,0x70,
0x00,0x3F,0xFF,0xC7,0xFF,0xF8,0x38,0x00,0x07,0x00,0x03,0xFF,0xF8,0x7F,0xFF,0x03,
0x80,0x00,0x38,0x00,0x07,0x00,0x00,0xF0,0x00,0x0F,0x00,0x00,0xF8,0x30,0x0F,0xFE,
0x00,0xFF,0xC0,0x07,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0081 21x40 -- 
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x82,0x00,0x04,0x10,0x00,0x20,
0x80,0x01,0x04,0x00,0x08,0x20,0x00,0x41,0x00,0x02,0x08,0x00,0x10,0x40,0x00,0x82,
0x00,0x04,0x10,0x00,0x20,0x80,0x01,0x04,0x00,0x08,0x20,0x00,0x41,0x00,0x02,0x08,
0x00,0x10,0x40,0x00,0x82,0x00,0x04,0x10,0x00,0x20,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

static unsigned char * ISO_88591_40GetCharacterFontBit(unsigned short ch, unsigned short *font_width)
{
    int iIndex, iUpPos = 0, iDownPos = TOTAL_CHARACTER_NUM;
//    unsigned char *font_dat = NULL;
    
    while(iUpPos <= iDownPos){
        iIndex = (iUpPos + iDownPos) >> 1 ;
        if(ISO_88591_40_font_map[iIndex].character == ch) //found this character
            break ;
        else if(ISO_88591_40_font_map[iIndex].character > ch)
            iDownPos = iIndex - 1;
        else
            iUpPos = iIndex + 1;
    }
    if(iUpPos > iDownPos)//don't found character font data
        iIndex = 0 ;//use first character font data
    *font_width = ISO_88591_40_font_map[iIndex].width ;
    return (unsigned char *)&ISO_88591_40_osdfont_dat[ISO_88591_40_font_map[iIndex].offset] ;
}

FONT ISO_88591_40Font = {
	"ISO_88591_40",
	40,
	0,
	40,
	0,
	GAPS_BETWEEN_CHARACTER,
	TOTAL_CHARACTER_NUM,
	ISO_88591_40GetCharacterFontBit
} ;

#undef GAPS_BETWEEN_CHARACTER
#undef TOTAL_CHARACTER_NUM
#endif